/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.application.impl.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eximeebpms.bpm.application.impl.EmbeddedProcessApplication;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.delegate.TaskListener;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.core.instance.CoreExecution;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ProcessApplicationEventListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/application/impl/event/pa.event.listener.eximeebpms.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected String deploymentId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.deploymentId = ((Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
    }

    @After
    public void closeDownProcessEngine() {
        this.managementService.unregisterProcessApplication(this.deploymentId, false);
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment(resources={"org/eximeebpms/bpm/application/impl/event/ProcessApplicationEventListenerTest.testExecutionListener.bpmn20.xml"})
    public void testExecutionListenerNull() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment(resources={"org/eximeebpms/bpm/application/impl/event/ProcessApplicationEventListenerTest.testExecutionListener.bpmn20.xml"})
    public void testShouldInvokeExecutionListenerOnStartAndEndOfProcessInstance() {
        final AtomicInteger processDefinitionEventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> {
                    if (((CoreExecution)execution).getEventSource() instanceof ProcessDefinitionEntity) {
                        processDefinitionEventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertEquals((long)2L, (long)processDefinitionEventCount.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment(resources={"org/eximeebpms/bpm/application/impl/event/ProcessApplicationEventListenerTest.testExecutionListener.bpmn20.xml"})
    public void testShouldNotIncrementExecutionListenerCountOnStartAndEndOfProcessInstance() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> {
                    if (!(((CoreExecution)execution).getEventSource() instanceof ProcessDefinitionEntity)) {
                        eventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertEquals((long)5L, (long)eventCount.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testExecutionListener() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> eventCount.incrementAndGet();
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertEquals((long)7L, (long)eventCount.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testExecutionListenerWithErrorBoundaryEvent() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> eventCount.incrementAndGet();
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Assert.assertEquals((long)10L, (long)eventCount.get());
        eventCount.set(0);
        this.runtimeService.startProcessInstanceByKey("executionListener", Collections.singletonMap("shouldThrowError", true));
        Assert.assertEquals((long)12L, (long)eventCount.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testExecutionListenerWithTimerBoundaryEvent() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> eventCount.incrementAndGet();
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)10L, (long)eventCount.get());
        eventCount.set(0);
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Assert.assertEquals((long)12L, (long)eventCount.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testExecutionListenerWithSignalBoundaryEvent() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> eventCount.incrementAndGet();
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)10L, (long)eventCount.get());
        eventCount.set(0);
        this.runtimeService.startProcessInstanceByKey("executionListener");
        this.runtimeService.signalEventReceived("signal");
        Assert.assertEquals((long)12L, (long)eventCount.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testExecutionListenerWithMultiInstanceBody() {
        final AtomicInteger eventCountForMultiInstanceBody = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return execution -> {
                    if ("miTasks#multiInstanceBody".equals(execution.getCurrentActivityId()) && ("start".equals(execution.getEventName()) || "end".equals(execution.getEventName()))) {
                        eventCountForMultiInstanceBody.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        List miTasks = this.taskService.createTaskQuery().list();
        for (Task task : miTasks) {
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)2L, (long)eventCountForMultiInstanceBody.get());
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testTaskListener() {
        final ArrayList events = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public TaskListener getTaskListener() {
                return delegateTask -> events.add(delegateTask.getEventName());
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        ProcessInstance taskListenerProcess = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"create", events.get(0));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "jonny");
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertEquals((Object)"update", events.get(1));
        Assert.assertEquals((Object)"assignment", events.get(2));
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)5L, (long)events.size());
        Assert.assertEquals((Object)"complete", events.get(3));
        Assert.assertEquals((Object)"create", events.get(4));
        this.runtimeService.deleteProcessInstance(taskListenerProcess.getProcessInstanceId(), "test delete event");
        Assert.assertEquals((long)6L, (long)events.size());
        Assert.assertEquals((Object)"delete", events.get(5));
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testIntermediateTimerEvent() {
        final ArrayList timerEvents = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return delegateExecution -> {
                    String currentActivityId = delegateExecution.getCurrentActivityId();
                    String eventName = delegateExecution.getEventName();
                    if ("timer".equals(currentActivityId) && ("start".equals(eventName) || "end".equals(eventName))) {
                        timerEvents.add(delegateExecution.getEventName());
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)2L, (long)timerEvents.size());
        Assert.assertEquals((Object)"start", timerEvents.get(0));
        Assert.assertEquals((Object)"end", timerEvents.get(1));
    }

    @Test
    @org.eximeebpms.bpm.engine.test.Deployment
    public void testIntermediateSignalEvent() {
        final ArrayList timerEvents = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return delegateExecution -> {
                    String currentActivityId = delegateExecution.getCurrentActivityId();
                    String eventName = delegateExecution.getEventName();
                    if ("signal".equals(currentActivityId) && ("start".equals(eventName) || "end".equals(eventName))) {
                        timerEvents.add(delegateExecution.getEventName());
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.signalEventReceived("abort");
        Assert.assertEquals((long)2L, (long)timerEvents.size());
        Assert.assertEquals((Object)"start", timerEvents.get(0));
        Assert.assertEquals((Object)"end", timerEvents.get(1));
    }
}

