/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.batch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BatchInvocationsPerJobByBatchTypeTest {
    @Rule
    public ProvidedProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ProcessEngineConfigurationImpl engineConfiguration;

    @Before
    public void assignServices() {
        this.managementService = this.processEngineRule.getManagementService();
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.historyService = this.processEngineRule.getHistoryService();
        this.engineConfiguration = this.processEngineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        int defaultInvocationsPerJob = 1;
        this.engineConfiguration.setInvocationsPerBatchJobByBatchType(new HashMap()).setInvocationsPerBatchJob(defaultInvocationsPerJob);
        this.managementService.createBatchQuery().list().forEach(this::cascadeDeleteBatch);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldFallbackToDefaultConfigurationWhenBatchTypeIsNotConfigured() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batchOne = this.runtimeService.deleteProcessInstancesAsync(processInstanceQuery, "");
        Assertions.assertThat((int)batchOne.getInvocationsPerBatchJob()).isEqualTo(1);
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldFallbackToGlobalConfigurationWhenBatchTypeIsNotConfigured() {
        Map<String, Integer> invocationsPerBatchJobByBatchType = Collections.singletonMap("instance-deletion", 10);
        this.engineConfiguration.setInvocationsPerBatchJobByBatchType(invocationsPerBatchJobByBatchType).setInvocationsPerBatchJob(42);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batchOne = this.runtimeService.deleteProcessInstancesAsync(processInstanceQuery, "");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(historicProcessInstanceQuery, "");
        Assertions.assertThat((int)batchOne.getInvocationsPerBatchJob()).isEqualTo(10);
        Assertions.assertThat((int)batchTwo.getInvocationsPerBatchJob()).isEqualTo(42);
    }

    protected void cascadeDeleteBatch(Batch batch) {
        this.managementService.deleteBatch(batch.getId(), true);
    }
}

