/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.util;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

public class ClockUtilTest {
    private static final long ONE_SECOND = 1000L;
    private static final long TWO_SECONDS = 2000L;
    private static final long FIVE_SECONDS = 5000L;
    private static final long TWO_DAYS = 172800000L;

    @Before
    public void setUp() throws Exception {
        ClockUtil.reset();
    }

    @AfterClass
    public static void resetClock() {
        ClockUtil.reset();
    }

    @Test
    public void nowShouldReturnCurrentTime() {
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(new Date(), 1000L);
    }

    @Test
    public void getCurrentTimeShouldReturnSameValueAsNow() {
        Assertions.assertThat((Date)ClockUtil.getCurrentTime()).isCloseTo(ClockUtil.now(), 1000L);
    }

    @Test
    public void offsetShouldTravelInTime() throws InterruptedException {
        long duration = 172800000L;
        Date target = new Date(new Date().getTime() + duration);
        ClockUtil.offset((Long)duration);
        Thread.sleep(1100L);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(target, 2000L);
    }

    @Test
    public void setCurrentTimeShouldFreezeTime() throws InterruptedException {
        long duration = 172800000L;
        Date target = new Date(new Date().getTime() + duration);
        ClockUtil.setCurrentTime((Date)target);
        Thread.sleep(1100L);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(target, 1000L);
    }

    @Test
    public void resetClockShouldResetToCurrentTime() {
        long duration = 172800000L;
        Date target = new Date(new Date().getTime() + duration);
        ClockUtil.offset((Long)duration);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(target, 1000L);
        Assertions.assertThat((Date)ClockUtil.resetClock()).isCloseTo(new Date(), 1000L);
        Assertions.assertThat((Date)ClockUtil.getCurrentTime()).isCloseTo(new Date(), 1000L);
    }

    @Test
    public void resetShouldResetToCurrentTime() {
        long duration = 172800000L;
        Date target = new Date(new Date().getTime() + duration);
        ClockUtil.offset((Long)duration);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(target, 1000L);
        ClockUtil.reset();
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(new Date(), 1000L);
    }

    @Test
    public void timeShouldMoveOnAfterTravel() throws InterruptedException {
        Date now = new Date();
        long duration = 172800000L;
        Date target = new Date(now.getTime() + duration);
        ClockUtil.offset((Long)duration);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(target, 1000L);
        Thread.sleep(5000L);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(new Date(target.getTime() + 5000L), 1000L);
    }

    @Test
    public void timeShouldFreezeWithSetCurrentTime() throws InterruptedException {
        Date now = new Date();
        long duration = 172800000L;
        Date target = new Date(now.getTime() + duration);
        ClockUtil.setCurrentTime((Date)target);
        Thread.sleep(5000L);
        Assertions.assertThat((Date)ClockUtil.now()).isCloseTo(target, 1000L);
    }
}

