/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class UserOperationIdTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected String deploymentId;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected FormService formService;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.formService = this.engineRule.getFormService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testResolveTaskOperationId() {
        this.identityService.setAuthenticatedUserId("demo");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Resolve").taskId(taskId).list();
        List historicDetails = this.historyService.createHistoricDetailQuery().list();
        this.verifySameOperationId(userOperationLogEntries, historicDetails);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskFormOperationId() {
        this.identityService.setAuthenticatedUserId("demo");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Complete").taskId(taskId).list();
        List historicDetails = this.historyService.createHistoricDetailQuery().list();
        this.verifySameOperationId(userOperationLogEntries, historicDetails);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetTaskVariablesOperationId() {
        this.identityService.setAuthenticatedUserId("demo");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("SetVariable").taskId(taskId).list();
        List historicDetails = this.historyService.createHistoricDetailQuery().list();
        this.verifySameOperationId(userOperationLogEntries, historicDetails);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testWithoutAuthentication() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().taskId(taskId).list();
        Assert.assertEquals((long)0L, (long)userOperationLogEntries.size());
        List historicDetails = this.historyService.createHistoricDetailQuery().list();
        Assert.assertTrue((historicDetails.size() > 0 ? 1 : 0) != 0);
        for (HistoricDetail historicDetail : historicDetails) {
            Assert.assertNull((Object)historicDetail.getUserOperationId());
        }
    }

    @Test
    public void testSetTaskVariablesInServiceTask() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask().serviceTask().camundaExpression("${execution.setVariable('foo', 'bar')}")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        this.identityService.setAuthenticatedUserId("demo");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assert.assertNull((Object)historicDetail.getUserOperationId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessOperationId() {
        this.identityService.setAuthenticatedUserId("demo");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Create").processInstanceId(pi.getId()).list();
        List historicDetails = this.historyService.createHistoricDetailQuery().list();
        Assert.assertFalse((boolean)userOperationLogEntries.isEmpty());
        Assert.assertFalse((boolean)historicDetails.isEmpty());
        this.verifySameOperationId(userOperationLogEntries, historicDetails);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessAtActivityOperationId() {
        this.identityService.setAuthenticatedUserId("demo");
        ProcessInstance pi = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).setVariables((Map)this.getVariables())).execute();
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Create").processInstanceId(pi.getId()).list();
        List historicDetails = this.historyService.createHistoricDetailQuery().list();
        Assert.assertFalse((boolean)userOperationLogEntries.isEmpty());
        Assert.assertFalse((boolean)historicDetails.isEmpty());
        this.verifySameOperationId(userOperationLogEntries, historicDetails);
    }

    private void verifySameOperationId(List<UserOperationLogEntry> userOperationLogEntries, List<HistoricDetail> historicDetails) {
        Assert.assertTrue((String)"Operation log entry must exist", (userOperationLogEntries.size() > 0 ? 1 : 0) != 0);
        String operationId = userOperationLogEntries.get(0).getOperationId();
        Assert.assertNotNull((Object)operationId);
        Assert.assertTrue((String)"Some historic details are expected to be present", (historicDetails.size() > 0 ? 1 : 0) != 0);
        for (UserOperationLogEntry userOperationLogEntry : userOperationLogEntries) {
            Assert.assertEquals((String)"OperationIds must be the same", (Object)operationId, (Object)userOperationLogEntry.getOperationId());
        }
        for (HistoricDetail historicDetail : historicDetails) {
            Assert.assertEquals((String)"OperationIds must be the same", (Object)operationId, (Object)historicDetail.getUserOperationId());
        }
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue").putValue("anotherVariableName", (Object)"anotherVariableValue");
    }
}

