/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.job;

import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UpdateJobAuthorizationTest {
    static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    ManagementService managementService;
    RuntimeService runtimeService;
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected String deploymentId;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "someProcessInstanceId", "userId", new Permission[]{Permissions.UPDATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() throws Exception {
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldExecuteJob() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).start();
        this.managementService.executeJob(jobId);
        if (this.authRule.assertScenario(this.scenario)) {
            String taskDefinitionKey = ((Task)this.engineRule.getTaskService().createTaskQuery().singleResult()).getTaskDefinitionKey();
            Assertions.assertThat((String)taskDefinitionKey).isEqualTo((Object)"taskAfterBoundaryEvent");
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSuspendJobById() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).bindResource("someProcessInstanceId", "unexisting").start();
        this.managementService.suspendJobById(jobId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((boolean)job.isSuspended()).isTrue();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldActivateJobById() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).bindResource("someProcessInstanceId", "unexisting").start();
        this.managementService.activateJobById(jobId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((boolean)job.isSuspended()).isFalse();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSuspendJobByProcessInstanceId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).bindResource("someProcessInstanceId", "unexisting").start();
        this.managementService.suspendJobByProcessInstanceId(processInstanceId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((boolean)job.isSuspended()).isTrue();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldActivateJobByProcessInstanceId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).bindResource("someProcessInstanceId", "unexisting").start();
        this.managementService.activateJobByProcessInstanceId(processInstanceId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((boolean)job.isSuspended()).isFalse();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSuspendJobByJobDefinitionId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionIdByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", "*").bindResource("someProcessInstanceId", processInstanceId).start();
        this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstanceId);
            Assertions.assertThat((boolean)job.isSuspended()).isTrue();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldActivateJobByJobDefinitionId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobDefinitionId = this.selectJobDefinitionIdByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", "*").bindResource("someProcessInstanceId", processInstanceId).start();
        this.managementService.activateJobByJobDefinitionId(jobDefinitionId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstanceId);
            Assertions.assertThat((boolean)job.isSuspended()).isFalse();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSuspendJobByProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", "*").bindResource("someProcessInstanceId", processInstance.getId()).start();
        this.managementService.suspendJobByProcessDefinitionId(processInstance.getProcessDefinitionId());
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstance.getId());
            Assertions.assertThat((boolean)job.isSuspended()).isTrue();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldActivateJobByProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", "*").bindResource("someProcessInstanceId", processInstance.getId()).start();
        this.managementService.activateJobByProcessDefinitionId(processInstance.getProcessDefinitionId());
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstance.getId());
            Assertions.assertThat((boolean)job.isSuspended()).isFalse();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSuspendJobByProcessDefinitionKey() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", "*").bindResource("someProcessInstanceId", processInstanceId).start();
        this.managementService.suspendJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstanceId);
            Assertions.assertThat((boolean)job.isSuspended()).isTrue();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldActivateJobByProcessDefinitionKey() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", "*").bindResource("someProcessInstanceId", processInstanceId).start();
        this.managementService.activateJobByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstanceId);
            Assertions.assertThat((boolean)job.isSuspended()).isFalse();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSetJobDueDate() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).bindResource("someProcessInstanceId", "unexisting").start();
        this.managementService.setJobDuedate(jobId, null);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((Date)job.getDuedate()).isNull();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldDeleteJob() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstanceId).bindResource("someProcessInstanceId", "unexisting").start();
        this.managementService.deleteJob(jobId);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobByProcessInstanceId(processInstanceId);
            Assertions.assertThat((Object)job).isNull();
        }
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        return job;
    }

    protected Job selectJobById(String jobId) {
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        return job;
    }

    protected String selectJobDefinitionIdByProcessDefinitionKey(String processDefinitionKey) {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        return jobDefinition.getId();
    }
}

