/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.migration;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrateProcessInstanceSyncQueryTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected List<Authorization> authorizations;
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);

    @Before
    public void setUp() {
        this.authorizations = new ArrayList<Authorization>();
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        for (Authorization authorization : this.authorizations) {
            this.engineRule.getAuthorizationService().deleteAuthorization(authorization.getId());
        }
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    public void testMigrateWithQuery() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        ProcessInstance instance1 = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        ProcessInstance instance2 = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.grantAuthorization("user", (Resource)Resources.PROCESS_INSTANCE, instance2.getId(), (Permission)Permissions.READ);
        this.grantAuthorization("user", (Resource)Resources.PROCESS_DEFINITION, "*", (Permission)Permissions.MIGRATE_INSTANCE);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        this.authRule.enableAuthorization("user");
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceQuery(query).execute();
        this.authRule.disableAuthorization();
        ProcessInstance instance1AfterMigration = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(instance1.getId()).singleResult();
        Assert.assertEquals((Object)sourceDefinition.getId(), (Object)instance1AfterMigration.getProcessDefinitionId());
    }

    protected void grantAuthorization(String userId, Resource resource, String resourceId, Permission permission) {
        Authorization authorization = this.engineRule.getAuthorizationService().createNewAuthorization(1);
        authorization.setResource(resource);
        authorization.setResourceId(resourceId);
        authorization.addPermission(permission);
        authorization.setUserId(userId);
        this.engineRule.getAuthorizationService().saveAuthorization(authorization);
        this.authorizations.add(authorization);
    }
}

