/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cfg;

import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.SchemaOperationsProcessEngineBuild;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.test.TestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DmnDisabledTest {
    protected static ProcessEngineImpl processEngineImpl;

    @After
    public void cleanup() {
        TestHelper.dropSchema((ProcessEngineConfigurationImpl)processEngineImpl.getProcessEngineConfiguration());
        processEngineImpl.close();
        processEngineImpl = null;
    }

    @Test
    public void disabledDmn() {
        processEngineImpl = DmnDisabledTest.createProcessEngineImpl(false);
        TestHelper.createSchema((ProcessEngineConfigurationImpl)processEngineImpl.getProcessEngineConfiguration());
        processEngineImpl.getProcessEngineConfiguration().getCommandExecutorSchemaOperations().execute((Command)new SchemaOperationsProcessEngineBuild());
        Assert.assertEquals((long)0L, (long)processEngineImpl.getRepositoryService().createDecisionDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)processEngineImpl.getRepositoryService().createDecisionDefinitionQuery().list().size());
        Assert.assertEquals((long)0L, (long)processEngineImpl.getRepositoryService().createDecisionRequirementsDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)processEngineImpl.getRepositoryService().createDecisionRequirementsDefinitionQuery().list().size());
    }

    protected static ProcessEngineImpl createProcessEngineImpl(boolean dmnEnabled) {
        StandaloneInMemProcessEngineConfiguration config = (StandaloneInMemProcessEngineConfiguration)new CustomStandaloneInMemProcessEngineConfiguration().setProcessEngineName("database-dmn-test-engine").setDatabaseSchemaUpdate("false").setHistory("full").setJdbcUrl("jdbc:h2:mem:DatabaseDmnTest");
        config.setDmnEnabled(dmnEnabled);
        return (ProcessEngineImpl)config.buildProcessEngine();
    }

    protected static class CustomStandaloneInMemProcessEngineConfiguration
    extends StandaloneInMemProcessEngineConfiguration {
        protected CustomStandaloneInMemProcessEngineConfiguration() {
        }

        public ProcessEngine buildProcessEngine() {
            this.init();
            return new CreateNoSchemaProcessEngineImpl((ProcessEngineConfigurationImpl)this);
        }
    }

    protected static class CreateNoSchemaProcessEngineImpl
    extends ProcessEngineImpl {
        public CreateNoSchemaProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
            super(processEngineConfiguration);
        }

        protected void executeSchemaOperations() {
        }
    }
}

