/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.form;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.form.FormField;
import org.eximeebpms.bpm.engine.form.FormFieldValidationConstraint;
import org.eximeebpms.bpm.engine.form.TaskFormData;
import org.eximeebpms.bpm.engine.impl.form.type.DateFormType;
import org.eximeebpms.bpm.engine.impl.form.type.EnumFormType;
import org.eximeebpms.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.eximeebpms.bpm.engine.impl.form.validator.FormFieldValidatorException;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class FormDataTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testGetFormFieldBasicProperties() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldBasicProperties");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField formField1 = (FormField)formFields.get(0);
        Assert.assertNotNull((Object)formField1);
        Assert.assertEquals((Object)formField1.getId(), (Object)"formField1");
        Assert.assertEquals((Object)formField1.getLabel(), (Object)"Form Field 1");
        Assert.assertEquals((Object)"string", (Object)formField1.getTypeName());
        Assert.assertNotNull((Object)formField1.getType());
        FormField formField2 = (FormField)formFields.get(1);
        Assert.assertNotNull((Object)formField2);
        Assert.assertEquals((Object)formField2.getId(), (Object)"formField2");
        Assert.assertEquals((Object)formField2.getLabel(), (Object)"Form Field 2");
        Assert.assertEquals((Object)"boolean", (Object)formField2.getTypeName());
        Assert.assertNotNull((Object)formField1.getType());
    }

    @Deployment
    @Test
    public void testGetFormFieldBuiltInTypes() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldBuiltInTypes");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField stringField = (FormField)formFields.get(0);
        Assert.assertNotNull((Object)stringField);
        Assert.assertEquals((Object)"string", (Object)stringField.getTypeName());
        Assert.assertNotNull((Object)stringField.getType());
        Assert.assertEquals((Object)"someString", (Object)stringField.getDefaultValue());
        FormField longField = (FormField)formFields.get(1);
        Assert.assertNotNull((Object)longField);
        Assert.assertEquals((Object)"long", (Object)longField.getTypeName());
        Assert.assertNotNull((Object)longField.getType());
        Assert.assertEquals((Object)1L, (Object)longField.getDefaultValue());
        FormField booleanField = (FormField)formFields.get(2);
        Assert.assertNotNull((Object)booleanField);
        Assert.assertEquals((Object)"boolean", (Object)booleanField.getTypeName());
        Assert.assertNotNull((Object)booleanField.getType());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)booleanField.getDefaultValue());
        FormField dateField = (FormField)formFields.get(3);
        Assert.assertNotNull((Object)dateField);
        Assert.assertEquals((Object)"date", (Object)dateField.getTypeName());
        Assert.assertNotNull((Object)dateField.getType());
        Date dateValue = (Date)dateField.getDefaultValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateValue);
        Assert.assertEquals((long)10L, (long)calendar.get(5));
        Assert.assertEquals((long)0L, (long)calendar.get(2));
        Assert.assertEquals((long)2013L, (long)calendar.get(1));
        FormField enumField = (FormField)formFields.get(4);
        Assert.assertNotNull((Object)enumField);
        Assert.assertEquals((Object)"enum", (Object)enumField.getTypeName());
        Assert.assertNotNull((Object)enumField.getType());
        EnumFormType enumFormType = (EnumFormType)enumField.getType();
        Map values = enumFormType.getValues();
        Assert.assertEquals((Object)"A", values.get("a"));
        Assert.assertEquals((Object)"B", values.get("b"));
        Assert.assertEquals((Object)"C", values.get("c"));
    }

    @Deployment
    @Test
    public void testGetFormFieldProperties() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldProperties");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField stringField = (FormField)formFields.get(0);
        Map properties = stringField.getProperties();
        Assert.assertEquals((Object)"property1", properties.get("p1"));
        Assert.assertEquals((Object)"property2", properties.get("p2"));
    }

    @Deployment
    @Test
    public void testGetFormFieldValidationConstraints() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldValidationConstraints");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField field1 = (FormField)formFields.get(0);
        List validationConstraints = field1.getValidationConstraints();
        FormFieldValidationConstraint constraint1 = (FormFieldValidationConstraint)validationConstraints.get(0);
        Assert.assertEquals((Object)"maxlength", (Object)constraint1.getName());
        Assert.assertEquals((Object)"10", (Object)constraint1.getConfiguration());
        FormFieldValidationConstraint constraint2 = (FormFieldValidationConstraint)validationConstraints.get(1);
        Assert.assertEquals((Object)"minlength", (Object)constraint2.getName());
        Assert.assertEquals((Object)"5", (Object)constraint2.getConfiguration());
    }

    @Deployment
    @Test
    public void testFormFieldSubmit() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("FormDataTest.testFormFieldSubmit");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, Object> formValues = new HashMap<String, Object>();
        formValues.put("stringField", "12345");
        formValues.put("longField", 9L);
        formValues.put("customField", "validValue");
        this.formService.submitTaskForm(task.getId(), formValues);
        Assert.assertEquals(formValues, (Object)this.runtimeService.getVariables(processInstance.getId()));
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test complete");
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testFormFieldSubmit");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        formValues = new HashMap();
        formValues.put("stringField", "1234");
        formValues.put("longField", 9L);
        formValues.put("customField", "validValue");
        try {
            this.formService.submitTaskForm(task.getId(), formValues);
            Assert.fail();
        }
        catch (FormFieldValidatorException e) {
            Assert.assertEquals((Object)e.getName(), (Object)"minlength");
        }
        formValues = new HashMap();
        formValues.put("customFieldWithValidationDetails", "C");
        try {
            this.formService.submitTaskForm(task.getId(), formValues);
            Assert.fail();
        }
        catch (FormFieldValidatorException e) {
            Assert.assertEquals((Object)e.getName(), (Object)"validator");
            Assert.assertEquals((Object)e.getId(), (Object)"customFieldWithValidationDetails");
            Assert.assertTrue((boolean)(e.getCause() instanceof FormFieldValidationException));
            FormFieldValidationException exception = (FormFieldValidationException)e.getCause();
            Assert.assertEquals((Object)exception.getDetail(), (Object)"EXPIRED");
        }
    }

    @Deployment
    @Test
    public void testSubmitFormDataWithEmptyDate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("FormDataTest.testSubmitFormDataWithEmptyDate");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> formValues = new HashMap<String, String>();
        formValues.put("stringField", "12345");
        formValues.put("dateField", "");
        this.formService.submitTaskForm(task.getId(), formValues);
        formValues.put("dateField", null);
        Assert.assertEquals(formValues, (Object)this.runtimeService.getVariables(processInstance.getId()));
    }

    @Deployment
    @Test
    public void testMissingFormVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("date-form-property-test");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        Assert.assertNotNull((Object)taskFormData);
        Assert.assertEquals((long)5L, (long)taskFormData.getFormFields().size());
        for (FormField field : taskFormData.getFormFields()) {
            Assert.assertNotNull((Object)field);
            if (field.getType() instanceof DateFormType) {
                Assert.assertEquals((Object)"", (Object)field.getValue().getValue());
                continue;
            }
            Assert.assertNull((Object)field.getValue().getValue());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/FormDataTest.testDoubleQuotesAreEscapedInGeneratedTaskForms.bpmn20.xml"})
    @Test
    public void testDoubleQuotesAreEscapedInGeneratedTaskForms() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "This is a \"Test\" message!");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task taskWithForm = (Task)this.taskService.createTaskQuery().singleResult();
        Object renderedStartForm = this.formService.getRenderedTaskForm(taskWithForm.getId());
        Assert.assertTrue((boolean)(renderedStartForm instanceof String));
        String renderedForm = (String)renderedStartForm;
        String expectedFormValueWithEscapedQuotes = "This is a &quot;Test&quot; message!";
        Assert.assertTrue((boolean)renderedForm.contains(expectedFormValueWithEscapedQuotes));
    }
}

