/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoryCleanupBatchWindowForWeekDaysTest {
    protected String defaultStartTime;
    protected String defaultEndTime;
    protected int defaultBatchSize;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setHistoryCleanupBatchSize(20);
        configuration.setHistoryCleanupBatchThreshold(10);
        configuration.setDefaultNumberOfRetries(5);
        configuration.setMondayHistoryCleanupBatchWindowStartTime("22:00");
        configuration.setMondayHistoryCleanupBatchWindowEndTime("01:00");
        configuration.setTuesdayHistoryCleanupBatchWindowStartTime("22:00");
        configuration.setTuesdayHistoryCleanupBatchWindowEndTime("23:00");
        configuration.setWednesdayHistoryCleanupBatchWindowStartTime("15:00");
        configuration.setWednesdayHistoryCleanupBatchWindowEndTime("20:00");
        configuration.setFridayHistoryCleanupBatchWindowStartTime("22:00");
        configuration.setFridayHistoryCleanupBatchWindowEndTime("01:00");
        configuration.setSundayHistoryCleanupBatchWindowStartTime("10:00");
        configuration.setSundayHistoryCleanupBatchWindowEndTime("20:00");
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    private HistoryService historyService;
    private ManagementService managementService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @Parameterized.Parameter(value=0)
    public Date currentDate;
    @Parameterized.Parameter(value=1)
    public Date startDateForCheck;
    @Parameterized.Parameter(value=2)
    public Date endDateForCheck;
    @Parameterized.Parameter(value=3)
    public Date startDateForCheckWithDefaultValues;
    @Parameterized.Parameter(value=4)
    public Date endDateForCheckWithDefaultValues;

    @Parameterized.Parameters
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({sdf.parse("2018-05-14T10:00:00"), sdf.parse("2018-05-14T22:00:00"), sdf.parse("2018-05-15T01:00:00"), null, null}, {sdf.parse("2018-05-14T23:00:00"), sdf.parse("2018-05-14T22:00:00"), sdf.parse("2018-05-15T01:00:00"), null, null}, {sdf.parse("2018-05-15T00:30:00"), sdf.parse("2018-05-14T22:00:00"), sdf.parse("2018-05-15T01:00:00"), null, null}, {sdf.parse("2018-05-15T02:00:00"), sdf.parse("2018-05-15T22:00:00"), sdf.parse("2018-05-15T23:00:00"), null, null}, {sdf.parse("2018-05-15T23:30:00"), sdf.parse("2018-05-16T15:00:00"), sdf.parse("2018-05-16T20:00:00"), null, null}, {sdf.parse("2018-05-16T21:00:00"), sdf.parse("2018-05-18T22:00:00"), sdf.parse("2018-05-19T01:00:00"), sdf.parse("2018-05-17T23:00:00"), sdf.parse("2018-05-18T00:00:00")}, {sdf.parse("2018-05-20T09:00:00"), sdf.parse("2018-05-20T10:00:00"), sdf.parse("2018-05-20T20:00:00"), null, null});
    }

    @Before
    public void init() {
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getManagementService();
        this.defaultStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTime();
        this.defaultEndTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTime();
        this.defaultBatchSize = this.processEngineConfiguration.getHistoryCleanupBatchSize();
    }

    @After
    public void clearDatabase() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(this.defaultStartTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(this.defaultEndTime);
        this.processEngineConfiguration.setHistoryCleanupBatchSize(this.defaultBatchSize);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupBatchWindowForWeekDaysTest.this.managementService.createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
    }

    @Test
    public void testScheduleJobForBatchWindow() throws ParseException {
        ClockUtil.setCurrentTime((Date)this.currentDate);
        this.processEngineConfiguration.initHistoryCleanup();
        Job job = this.historyService.cleanUpHistoryAsync();
        Assert.assertFalse((boolean)this.startDateForCheck.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheck.after(job.getDuedate()));
        ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.endDateForCheck, (int)-1));
        job = this.historyService.cleanUpHistoryAsync();
        Assert.assertFalse((boolean)this.startDateForCheck.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheck.after(job.getDuedate()));
        ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.endDateForCheck, (int)1));
        job = this.historyService.cleanUpHistoryAsync();
        Assert.assertTrue((boolean)this.endDateForCheck.before(job.getDuedate()));
    }

    @Test
    public void testScheduleJobForBatchWindowWithDefaultWindowConfigured() throws ParseException {
        ClockUtil.setCurrentTime((Date)this.currentDate);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("00:00");
        this.processEngineConfiguration.initHistoryCleanup();
        Job job = this.historyService.cleanUpHistoryAsync();
        if (this.startDateForCheckWithDefaultValues == null) {
            this.startDateForCheckWithDefaultValues = this.startDateForCheck;
        }
        if (this.endDateForCheckWithDefaultValues == null) {
            this.endDateForCheckWithDefaultValues = this.endDateForCheck;
        }
        Assert.assertFalse((boolean)this.startDateForCheckWithDefaultValues.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheckWithDefaultValues.after(job.getDuedate()));
        ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.endDateForCheckWithDefaultValues, (int)-1));
        job = this.historyService.cleanUpHistoryAsync();
        Assert.assertFalse((boolean)this.startDateForCheckWithDefaultValues.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheckWithDefaultValues.after(job.getDuedate()));
        ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.endDateForCheckWithDefaultValues, (int)1));
        job = this.historyService.cleanUpHistoryAsync();
        Assert.assertTrue((boolean)this.endDateForCheckWithDefaultValues.before(job.getDuedate()));
    }

    @Test
    public void testScheduleJobForBatchWindowWithShortcutConfiguration() throws ParseException {
        ClockUtil.setCurrentTime((Date)this.currentDate);
        this.processEngineConfiguration.setThursdayHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setThursdayHistoryCleanupBatchWindowEndTime("00:00");
        this.processEngineConfiguration.setSaturdayHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setSaturdayHistoryCleanupBatchWindowEndTime("00:00");
        this.processEngineConfiguration.initHistoryCleanup();
        Job job = this.historyService.cleanUpHistoryAsync();
        if (this.startDateForCheckWithDefaultValues == null) {
            this.startDateForCheckWithDefaultValues = this.startDateForCheck;
        }
        if (this.endDateForCheckWithDefaultValues == null) {
            this.endDateForCheckWithDefaultValues = this.endDateForCheck;
        }
        Assert.assertFalse((boolean)this.startDateForCheckWithDefaultValues.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheckWithDefaultValues.after(job.getDuedate()));
        ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.endDateForCheckWithDefaultValues, (int)-1));
        job = this.historyService.cleanUpHistoryAsync();
        Assert.assertFalse((boolean)this.startDateForCheckWithDefaultValues.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheckWithDefaultValues.after(job.getDuedate()));
        ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.endDateForCheckWithDefaultValues, (int)1));
        job = this.historyService.cleanUpHistoryAsync();
        Assert.assertTrue((boolean)this.endDateForCheckWithDefaultValues.before(job.getDuedate()));
    }
}

