/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class AdminGroupsTest {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    protected void cleanupAfterTest() {
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void testWithoutAdminGroup() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.newUser("jonny1");
        this.identityService.setAuthentication("nonAdmin", null, null);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.unlockUser("jonny1")).isInstanceOf(AuthorizationException.class)).hasMessageContaining("Required admin authenticated group or user.");
    }

    @Test
    public void testWithAdminGroup() {
        this.processEngineConfiguration.getAdminGroups().add("adminGroup");
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.setAuthentication("admin", Collections.singletonList("adminGroup"), null);
        Authorization userAuth = this.authorizationService.createNewAuthorization(1);
        userAuth.setUserId("admin");
        userAuth.setResource((Resource)Resources.USER);
        userAuth.setResourceId("*");
        userAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(userAuth);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.unlockUser("jonny1");
    }
}

