/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.AuthorizationQuery;
import org.eximeebpms.bpm.engine.authorization.BatchPermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.ProcessInstancePermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AuthorizationQueryAuthorizationsTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationService authorizationService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    @Test
    public void testQuerySingleCorrectPermission() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.PROCESS_DEFINITION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).count());
    }

    @Test
    public void testQuerySingleIncorrectPermission() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.BATCH);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.BATCH).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.CREATE_INSTANCE).count());
    }

    @Test
    public void testQueryPermissionsWithWrongResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.APPLICATION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Authorization accessResult = (Authorization)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.ACCESS).singleResult();
        List retryJobPDResult = this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB).list();
        List retryJobPIResult = this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessInstancePermissions.RETRY_JOB).list();
        Assert.assertNotNull((Object)accessResult);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.ACCESS).count());
        Assert.assertTrue((boolean)retryJobPDResult.isEmpty());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB).count());
        Assert.assertTrue((boolean)retryJobPIResult.isEmpty());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)ProcessInstancePermissions.RETRY_JOB).count());
    }

    @Test
    public void testQueryPermissionWithMixedResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.APPLICATION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.BATCH).hasPermission((Permission)Permissions.ACCESS).count());
    }

    @Test
    public void testQueryPermissionsWithMixedResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.PROCESS_DEFINITION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.PROCESS_DEFINITION).hasPermission((Permission)ProcessDefinitionPermissions.READ).hasPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.PROCESS_DEFINITION).hasPermission((Permission)ProcessDefinitionPermissions.READ).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.PROCESS_DEFINITION).hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.ACCESS).count());
    }

    @Test
    public void testQueryCorrectAndIncorrectPersmission() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Authorization authResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"userId"}).resourceType((Resource)Resources.PROCESS_DEFINITION).singleResult();
        Assert.assertNotNull((Object)authResult);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.ACCESS).count());
    }

    @Test
    public void shouldNotFindAllAuthorizationsWithRevokedReadPermissionOnOneAuthorization() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)ProcessDefinitionPermissions.RETRY_JOB);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("*");
        authorization.setResource((Resource)Resources.AUTHORIZATION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        authorization = this.authorizationService.createNewAuthorization(2);
        authorization.setUserId("userId");
        authorization.setResource((Resource)Resources.AUTHORIZATION);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.processEngineConfiguration.getIdentityService().setAuthenticatedUserId("userId");
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery();
        long authorizationsCount = authQuery.count();
        List authorizations = authQuery.list();
        Assert.assertEquals((long)0L, (long)authorizationsCount);
        Assert.assertEquals((long)0L, (long)authorizations.size());
    }

    protected void cleanupAfterTest() {
        this.processEngineConfiguration.getIdentityService().clearAuthentication();
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

