/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.mgmt.FailingDelegate;
import org.eximeebpms.bpm.engine.test.api.runtime.util.ChangeVariablesDelegate;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobEntityTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected List<String> jobIds = new ArrayList<String>();
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected static final Date CREATE_DATE = new Date(1363607000000L);
    protected String activityIdLoggingProperty;

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.jobIds = new ArrayList<String>();
        this.activityIdLoggingProperty = this.engineRule.getProcessEngineConfiguration().getLoggingContextActivityId();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)CREATE_DATE);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void cleanup() {
        for (String jobId : this.jobIds) {
            this.managementService.deleteJob(jobId);
        }
        if (!this.testRule.isHistoryLevelNone()) {
            this.cleanupJobLog();
        }
        this.engineRule.getProcessEngineConfiguration().setLoggingContextActivityId(this.activityIdLoggingProperty);
    }

    @Test
    public void shouldCheckCreateTimeOnMessage() {
        this.testRule.deploy(((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().camundaAsyncBefore()).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        Job messageJob = (Job)this.managementService.createJobQuery().singleResult();
        MatcherAssert.assertThat((Object)messageJob.getCreateTime(), (Matcher)Matchers.is((Object)CREATE_DATE));
        MatcherAssert.assertThat((Object)messageJob.getClass().getSimpleName(), (Matcher)Matchers.is((Object)"MessageEntity"));
        this.jobIds.add(messageJob.getId());
    }

    @Test
    public void shouldCheckCreateTimeOnTimer() {
        this.testRule.deploy(((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().timerWithDuration("PT5S")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        MatcherAssert.assertThat((Object)timerJob.getCreateTime(), (Matcher)Matchers.is((Object)CREATE_DATE));
        MatcherAssert.assertThat((Object)timerJob.getClass().getSimpleName(), (Matcher)Matchers.is((Object)"TimerEntity"));
        this.jobIds.add(timerJob.getId());
    }

    @Test
    public void shouldCheckCreateTimeOnEverLivingJob() {
        this.historyService.cleanUpHistoryAsync(true);
        Job everLivingJob = (Job)this.managementService.createJobQuery().singleResult();
        MatcherAssert.assertThat((Object)everLivingJob.getCreateTime(), (Matcher)Matchers.is((Object)CREATE_DATE));
        MatcherAssert.assertThat((Object)everLivingJob.getClass().getSimpleName(), (Matcher)Matchers.is((Object)"EverLivingJobEntity"));
        this.jobIds.add(everLivingJob.getId());
    }

    @Test
    public void shouldShowFailedActivityIdPropertyForFailingAsyncTask() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theTask").camundaAsyncBefore()).camundaClass(FailingDelegate.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (JobEntity)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        MatcherAssert.assertThat((Object)job.getFailedActivityId(), (Matcher)Matchers.is((Object)"theTask"));
    }

    @Test
    public void shouldShowFailedActivityIdIfActivityIdLoggingIsDisabled() {
        this.engineRule.getProcessEngineConfiguration().setLoggingContextActivityId(null);
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theTask").camundaAsyncBefore()).camundaClass(FailingDelegate.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (JobEntity)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        MatcherAssert.assertThat((Object)job.getFailedActivityId(), (Matcher)Matchers.is((Object)"theTask"));
    }

    @Test
    public void shouldShowFailedActivityIdPropertyForAsyncTaskWithFailingFollowUp() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theTask").camundaAsyncBefore()).camundaClass(ChangeVariablesDelegate.class)).serviceTask("theTask2").camundaClass(ChangeVariablesDelegate.class)).serviceTask("theTask3").camundaClass(FailingDelegate.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (JobEntity)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        MatcherAssert.assertThat((Object)job.getFailedActivityId(), (Matcher)Matchers.is((Object)"theTask3"));
    }

    protected void cleanupJobLog() {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String jobId : JobEntityTest.this.jobIds) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
    }
}

