/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt.metrics;

import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.metrics.MetricsQueryImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.management.MetricIntervalValue;
import org.eximeebpms.bpm.engine.management.MetricsQuery;
import org.eximeebpms.bpm.engine.test.api.mgmt.metrics.AbstractMetricsIntervalTest;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class MetricsIntervalTest
extends AbstractMetricsIntervalTest {
    @Test
    public void testMeterQueryLimit() {
        MetricsQueryImpl query = (MetricsQueryImpl)this.managementService.createMetricsQuery();
        TestCase.assertEquals((int)1, (int)query.getFirstRow());
        TestCase.assertEquals((int)0, (int)query.getFirstResult());
        TestCase.assertEquals((int)200, (int)query.getMaxResults());
        TestCase.assertEquals((int)201, (int)query.getLastRow());
    }

    @Test
    public void testMeterQueryDecreaseLimit() {
        List metrics = this.managementService.createMetricsQuery().limit(10).interval();
        TestCase.assertEquals((int)10, (int)metrics.size());
    }

    @Test
    public void testMeterQueryIncreaseLimit() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.createMetricsQuery().limit(1000).interval()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Metrics interval query row limit can't be set larger than 200.");
    }

    @Test
    public void testMeterQueryOffset() {
        List metrics = this.managementService.createMetricsQuery().offset(this.metricsCount).interval();
        TestCase.assertEquals((int)(2 * this.metricsCount), (int)metrics.size());
        TestCase.assertEquals((long)this.firstInterval.plusMinutes(15).getMillis(), (long)((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime());
    }

    @Test
    public void testMeterQueryMaxOffset() {
        List metrics = this.managementService.createMetricsQuery().offset(Integer.MAX_VALUE).interval();
        TestCase.assertEquals((int)0, (int)metrics.size());
    }

    @Test
    public void testMeterQueryDefaultInterval() {
        List metrics = this.managementService.createMetricsQuery().interval();
        long lastTimestamp = ((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime();
        metrics.remove(0);
        for (MetricIntervalValue metric : metrics) {
            long nextTimestamp = metric.getTimestamp().getTime();
            if (lastTimestamp == nextTimestamp) continue;
            TestCase.assertEquals((long)lastTimestamp, (long)(nextTimestamp + 900000L));
            lastTimestamp = nextTimestamp;
        }
    }

    @Test
    public void testMeterQueryCustomInterval() {
        List metrics = this.managementService.createMetricsQuery().interval(300L);
        int interval = 300000;
        long lastTimestamp = ((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime();
        metrics.remove(0);
        for (MetricIntervalValue metric : metrics) {
            long nextTimestamp = metric.getTimestamp().getTime();
            if (lastTimestamp == nextTimestamp) continue;
            TestCase.assertEquals((long)lastTimestamp, (long)(nextTimestamp + (long)interval));
            lastTimestamp = nextTimestamp;
        }
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereReporter() {
        List metrics = this.managementService.createMetricsQuery().reporter("REPORTER_ID").interval();
        TestCase.assertEquals((int)(3 * this.metricsCount), (int)metrics.size());
        long lastTimestamp = ((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime();
        String reporter = ((MetricIntervalValue)metrics.get(0)).getReporter();
        metrics.remove(0);
        for (MetricIntervalValue metric : metrics) {
            TestCase.assertEquals((String)reporter, (String)metric.getReporter());
            long nextTimestamp = metric.getTimestamp().getTime();
            if (lastTimestamp == nextTimestamp) continue;
            TestCase.assertEquals((long)lastTimestamp, (long)(nextTimestamp + 900000L));
            lastTimestamp = nextTimestamp;
        }
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereReporterNotExist() {
        List metrics = this.managementService.createMetricsQuery().reporter("notExist").interval();
        TestCase.assertEquals((int)0, (int)metrics.size());
    }

    @Test
    public void testMeterQueryCustomIntervalWhereReporter() {
        int interval = 300;
        List metrics = this.managementService.createMetricsQuery().reporter("REPORTER_ID").interval((long)interval);
        TestCase.assertEquals((int)(9 * this.metricsCount), (int)metrics.size());
        interval *= 1000;
        long lastTimestamp = ((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime();
        String reporter = ((MetricIntervalValue)metrics.get(0)).getReporter();
        metrics.remove(0);
        for (MetricIntervalValue metric : metrics) {
            TestCase.assertEquals((String)reporter, (String)metric.getReporter());
            long nextTimestamp = metric.getTimestamp().getTime();
            if (lastTimestamp == nextTimestamp) continue;
            TestCase.assertEquals((long)lastTimestamp, (long)(nextTimestamp + (long)interval));
            lastTimestamp = nextTimestamp;
        }
    }

    @Test
    public void testMeterQueryCustomIntervalWhereReporterNotExist() {
        List metrics = this.managementService.createMetricsQuery().reporter("notExist").interval(300L);
        TestCase.assertEquals((int)0, (int)metrics.size());
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereName() {
        List metrics = this.managementService.createMetricsQuery().name("activity-instance-start").interval();
        TestCase.assertEquals((int)3, (int)metrics.size());
        long lastTimestamp = ((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime();
        String name = ((MetricIntervalValue)metrics.get(0)).getName();
        metrics.remove(0);
        for (MetricIntervalValue metric : metrics) {
            TestCase.assertEquals((String)name, (String)metric.getName());
            TestCase.assertEquals((String)"flow-node-instances", (String)metric.getName());
            long nextTimestamp = metric.getTimestamp().getTime();
            if (lastTimestamp == nextTimestamp) continue;
            TestCase.assertEquals((long)lastTimestamp, (long)(nextTimestamp + 900000L));
            lastTimestamp = nextTimestamp;
        }
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereNameNotExist() {
        List metrics = this.managementService.createMetricsQuery().name("notExist").interval();
        TestCase.assertEquals((int)0, (int)metrics.size());
    }

    @Test
    public void testMeterQueryCustomIntervalWhereName() {
        int interval = 300;
        List metrics = this.managementService.createMetricsQuery().name("activity-instance-start").interval((long)interval);
        TestCase.assertEquals((int)9, (int)metrics.size());
        interval *= 1000;
        long lastTimestamp = ((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime();
        String name = ((MetricIntervalValue)metrics.get(0)).getName();
        metrics.remove(0);
        for (MetricIntervalValue metric : metrics) {
            TestCase.assertEquals((String)name, (String)metric.getName());
            TestCase.assertEquals((String)"flow-node-instances", (String)metric.getName());
            long nextTimestamp = metric.getTimestamp().getTime();
            if (lastTimestamp == nextTimestamp) continue;
            TestCase.assertEquals((long)lastTimestamp, (long)(nextTimestamp + (long)interval));
            lastTimestamp = nextTimestamp;
        }
    }

    @Test
    public void testMeterQueryCustomIntervalWhereNameNotExist() {
        List metrics = this.managementService.createMetricsQuery().name("notExist").interval(300L);
        TestCase.assertEquals((int)0, (int)metrics.size());
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereStartDate() {
        Date startDate = this.firstInterval.plusMinutes(15).toDate();
        List metrics = this.managementService.createMetricsQuery().startDate(startDate).interval();
        TestCase.assertEquals((int)(2 * this.metricsCount), (int)metrics.size());
    }

    @Test
    public void testMeterQueryCustomIntervalWhereStartDate() {
        Date startDate = this.firstInterval.plusMinutes(15).toDate();
        List metrics = this.managementService.createMetricsQuery().startDate(startDate).interval(300L);
        TestCase.assertEquals((int)(6 * this.metricsCount), (int)metrics.size());
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereEndDate() {
        DateTime endDate = this.firstInterval.plusMinutes(15);
        List metrics = this.managementService.createMetricsQuery().endDate(endDate.toDate()).interval();
        TestCase.assertEquals((int)this.metricsCount, (int)metrics.size());
    }

    @Test
    public void testMeterQueryCustomIntervalWhereEndDate() {
        Date endDate = this.firstInterval.plusMinutes(15).toDate();
        List metrics = this.managementService.createMetricsQuery().endDate(endDate).interval(300L);
        TestCase.assertEquals((int)(3 * this.metricsCount), (int)metrics.size());
    }

    @Test
    public void testMeterQueryDefaultIntervalWhereStartAndEndDate() {
        DateTime endDate = this.firstInterval.plusMinutes(15);
        DateTime startDate = this.firstInterval;
        List metrics = this.managementService.createMetricsQuery().startDate(startDate.toDate()).endDate(endDate.toDate()).interval();
        TestCase.assertEquals((int)this.metricsCount, (int)metrics.size());
    }

    @Test
    public void testMeterQueryCustomIntervalWhereStartAndEndDate() {
        DateTime endDate = this.firstInterval.plusMinutes(15);
        DateTime startDate = this.firstInterval;
        List metrics = this.managementService.createMetricsQuery().startDate(startDate.toDate()).endDate(endDate.toDate()).interval(300L);
        TestCase.assertEquals((int)(3 * this.metricsCount), (int)metrics.size());
    }

    @Test
    public void testMeterQueryDefaultIntervalCalculatedValue() {
        DateTime endDate = this.firstInterval.plusMinutes(15);
        DateTime startDate = this.firstInterval;
        MetricsQuery metricQuery = this.managementService.createMetricsQuery().startDate(startDate.toDate()).endDate(endDate.toDate()).name("activity-instance-start");
        List metrics = metricQuery.interval();
        long sum = metricQuery.sum();
        TestCase.assertEquals((int)1, (int)metrics.size());
        TestCase.assertEquals((long)sum, (long)((MetricIntervalValue)metrics.get(0)).getValue());
    }

    @Test
    public void testMeterQueryCustomIntervalCalculatedValue() {
        DateTime endDate = this.firstInterval.plusMinutes(15);
        DateTime startDate = this.firstInterval;
        MetricsQuery metricQuery = this.managementService.createMetricsQuery().startDate(startDate.toDate()).endDate(endDate.toDate()).name("activity-instance-start");
        List metrics = metricQuery.interval(300L);
        long sum = metricQuery.sum();
        TestCase.assertEquals((int)3, (int)metrics.size());
        long summedValue = 0L;
        summedValue += ((MetricIntervalValue)metrics.get(0)).getValue();
        summedValue += ((MetricIntervalValue)metrics.get(1)).getValue();
        TestCase.assertEquals((long)sum, (long)(summedValue += ((MetricIntervalValue)metrics.get(2)).getValue()));
    }

    @Test
    public void testMeterQueryNotLoggedInterval() {
        List metrics = this.managementService.createMetricsQuery().name("activity-instance-start").limit(1).interval();
        long value = ((MetricIntervalValue)metrics.get(0)).getValue();
        this.processEngineConfiguration.getMetricsRegistry().markOccurrence("activity-instance-start", 3L);
        metrics = this.managementService.createMetricsQuery().name("activity-instance-start").limit(1).interval();
        long newValue = ((MetricIntervalValue)metrics.get(0)).getValue();
        Assert.assertTrue((value + 3L == newValue ? 1 : 0) != 0);
        metrics = this.managementService.createMetricsQuery().interval();
        for (MetricIntervalValue intervalValue : metrics) {
            if (!intervalValue.getName().equalsIgnoreCase("activity-instance-start")) continue;
            newValue = intervalValue.getValue();
            Assert.assertTrue((value + 3L == newValue ? 1 : 0) != 0);
            break;
        }
        this.clearLocalMetrics();
    }

    @Test
    public void testIntervallQueryWithGeneratedDataAfterSomeTime() {
        List metrics = this.managementService.createMetricsQuery().interval();
        Date lastInterval = ((MetricIntervalValue)metrics.get(0)).getTimestamp();
        long nextTime = lastInterval.getTime() + 900000L;
        ClockUtil.setCurrentTime((Date)new Date(nextTime));
        this.reportMetrics();
        List newMetrics = this.managementService.createMetricsQuery().interval();
        Assert.assertNotEquals((long)metrics.size(), (long)newMetrics.size());
        TestCase.assertEquals((int)(metrics.size() + this.metricsCount), (int)newMetrics.size());
        TestCase.assertEquals((long)((MetricIntervalValue)newMetrics.get(0)).getTimestamp().getTime(), (long)(((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime() + 900000L));
    }

    @Test
    public void testIntervallQueryWithGeneratedDataAfterSomeTimeForSpecificMetric() {
        List metrics = this.managementService.createMetricsQuery().name("activity-instance-start").startDate(new Date(0L)).endDate(new Date(180000000L)).interval();
        Date lastInterval = ((MetricIntervalValue)metrics.get(0)).getTimestamp();
        long nextTime = lastInterval.getTime() + 900000L;
        ClockUtil.setCurrentTime((Date)new Date(nextTime));
        this.reportMetrics();
        List newMetrics = this.managementService.createMetricsQuery().name("activity-instance-start").startDate(new Date(0L)).endDate(new Date(180000000L)).interval();
        Assert.assertNotEquals((long)metrics.size(), (long)newMetrics.size());
        TestCase.assertEquals((long)((MetricIntervalValue)newMetrics.get(0)).getTimestamp().getTime(), (long)(((MetricIntervalValue)metrics.get(0)).getTimestamp().getTime() + 900000L));
        TestCase.assertEquals((long)((MetricIntervalValue)metrics.get(0)).getValue(), (long)((MetricIntervalValue)newMetrics.get(1)).getValue());
        this.clearMetrics();
    }

    @Test
    public void testMetricQueryAggregatedByReporterSingleReporter() {
        List metrics = this.managementService.createMetricsQuery().interval();
        Assert.assertTrue((metrics.size() > 0 ? 1 : 0) != 0);
        List aggregatedMetrics = this.managementService.createMetricsQuery().aggregateByReporter().interval();
        TestCase.assertEquals((int)metrics.size(), (int)aggregatedMetrics.size());
        for (MetricIntervalValue metricIntervalValue : aggregatedMetrics) {
            Assert.assertNull((Object)metricIntervalValue.getReporter());
        }
    }

    @Test
    public void testMetricQueryAggregatedByReporterThreeReporters() {
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter1");
        this.generateMeterData(3L, 900000L);
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter2");
        this.generateMeterData(3L, 900000L);
        List metrics = this.managementService.createMetricsQuery().interval();
        List aggregatedMetrics = this.managementService.createMetricsQuery().aggregateByReporter().interval();
        TestCase.assertEquals((int)metrics.size(), (int)(aggregatedMetrics.size() * 3));
        for (MetricIntervalValue metricIntervalValue : aggregatedMetrics) {
            Assert.assertNull((Object)metricIntervalValue.getReporter());
        }
    }

    @Test
    public void testMetricQueryAggregatedByReporterLimitAndTwoReporters() {
        this.clearLocalMetrics();
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter1");
        this.generateMeterData(10L, 900000L);
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter2");
        this.generateMeterData(10L, 900000L);
        int limit = 10;
        List metrics = this.managementService.createMetricsQuery().name("activity-instance-start").limit(limit).interval();
        List aggregatedMetrics = this.managementService.createMetricsQuery().name("activity-instance-start").limit(limit).aggregateByReporter().interval();
        Assert.assertTrue((((MetricIntervalValue)metrics.get(limit - 1)).getTimestamp().getTime() > ((MetricIntervalValue)aggregatedMetrics.get(limit - 1)).getTimestamp().getTime() ? 1 : 0) != 0);
        TestCase.assertEquals((int)metrics.size(), (int)aggregatedMetrics.size());
    }
}

