/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt.telemetry;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngines;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.diagnostics.CommandCounter;
import org.eximeebpms.bpm.engine.impl.diagnostics.DiagnosticsRegistry;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.metrics.Meter;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryDynamicDataTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected ProcessEngine processEngineInMem;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
        this.managementService = this.configuration.getManagementService();
        this.clearMetrics();
    }

    @After
    public void tearDown() {
        this.clearMetrics();
        if (this.processEngineInMem != null) {
            ProcessEngines.unregister((ProcessEngine)this.processEngineInMem);
            this.processEngineInMem.close();
        }
    }

    public void clearMetrics() {
        this.configuration.getDiagnosticsRegistry().clear();
        this.clearMetrics(this.configuration.getMetricsRegistry().getDbMeters());
        this.clearMetrics(this.configuration.getMetricsRegistry().getDiagnosticsMeters());
        this.managementService.deleteMetrics(null);
    }

    protected void clearMetrics(Map<String, Meter> meters) {
        for (Meter meter : meters.values()) {
            meter.getAndClear();
        }
    }

    @Test
    public void shouldCountCommandsFromEngineStartAfterTelemetryActivation() {
        this.processEngineInMem = new StandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:eximeebpms" + this.getClass().getSimpleName()).buildProcessEngine();
        DiagnosticsRegistry telemetryRegistry = ((ProcessEngineConfigurationImpl)this.processEngineInMem.getProcessEngineConfiguration()).getDiagnosticsRegistry();
        Map entries = telemetryRegistry.getCommands();
        Assertions.assertThat(entries.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"GetTableMetaDataCmd", "HistoryCleanupCmd", "SchemaOperationsProcessEngineBuild", "HistoryLevelSetupCommand", "BootstrapEngineCommand", "GetLicenseKeyCmd"});
        for (String commandName : entries.keySet()) {
            Assertions.assertThat((long)((CommandCounter)entries.get(commandName)).get()).isEqualTo(1L);
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCountAfterCleaning() {
        this.clearCommandCounts();
        Map entries = this.configuration.getDiagnosticsRegistry().getCommands();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.setVariable(processInstanceId, "foo", (Object)"bar");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        this.taskService.complete(task.getId());
        Assertions.assertThat((int)entries.size()).isEqualTo(4);
        Object[] expectedExecutedCommands = new String[]{"StartProcessInstanceCmd", "SetExecutionVariablesCmd", "TaskQueryImpl", "CompleteTaskCmd"};
        Assertions.assertThat(entries.keySet()).contains(expectedExecutedCommands);
        for (Object commandName : expectedExecutedCommands) {
            Assertions.assertThat((long)((CommandCounter)entries.get(commandName)).get()).isEqualTo(1L);
        }
    }

    @Test
    public void shouldCollectInnerClasses() {
        this.configuration.getCommandExecutorTxRequired().execute((Command)new InnerClassCmd());
        this.configuration.getCommandExecutorTxRequired().execute((Command)new InnerClassCmd());
        Map commands = this.configuration.getDiagnosticsRegistry().getCommands();
        Object[] expectedExecutedCommands = new String[]{"TelemetryDynamicDataTest_InnerClassCmd"};
        Assertions.assertThat(commands.keySet()).contains(expectedExecutedCommands);
        Assertions.assertThat((long)((CommandCounter)commands.get("TelemetryDynamicDataTest_InnerClassCmd")).get()).isEqualTo(2L);
    }

    @Test
    public void shouldNotCollectAnonymousClasses() {
        this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                System.out.println("Test anonymous command.");
                return null;
            }
        });
        this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                System.out.println("Test anonymous command.");
                return null;
            }
        });
        Map commands = this.configuration.getDiagnosticsRegistry().getCommands();
        Assertions.assertThat(commands.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"DeleteMetricsCmd"});
    }

    @Test
    public void shouldNotCollectLambdas() {
        this.configuration.getCommandExecutorTxRequired().execute(commandContext -> {
            System.out.println("Test lambda as command.");
            return null;
        });
        Map commands = this.configuration.getDiagnosticsRegistry().getCommands();
        Assertions.assertThat(commands.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"DeleteMetricsCmd"});
    }

    protected void clearCommandCounts() {
        this.configuration.getDiagnosticsRegistry().clearCommandCounts();
    }

    protected static class InnerClassCmd
    implements Command<Void> {
        protected InnerClassCmd() {
        }

        public Void execute(CommandContext commandContext) {
            System.out.println("Test inner class command.");
            return null;
        }
    }
}

