/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt.telemetry;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.junit.Test;

@RequiredDatabase(includes={"h2"})
public class TelemetryStaticDataTest {
    @Test
    public void shouldValidateWildFlyVendor() {
        ApplicationServerImpl server = new ApplicationServerImpl("WildFly Full 19.0.0.Final (WildFly Core 11.0.0.Final) - 2.0.30.Final");
        Assertions.assertThat((String)server.getVendor()).isEqualTo((Object)"WildFly");
    }

    @Test
    public void shouldValidateJbossVendor() {
        ApplicationServerImpl server = new ApplicationServerImpl("JBoss EAP 7.2.0.GA (WildFly Core 6.0.11.Final-redhat-00001) - 2.0.15.Final-redhat-00001");
        Assertions.assertThat((String)server.getVendor()).isEqualTo((Object)"JBoss EAP");
    }

    @Test
    public void shouldValidateTomcatVendor() {
        ApplicationServerImpl server = new ApplicationServerImpl("Apache Tomcat/9.0.36");
        Assertions.assertThat((String)server.getVendor()).isEqualTo((Object)"Apache Tomcat");
    }

    @Test
    public void shouldValidateWebLogicVendor() {
        ApplicationServerImpl server = new ApplicationServerImpl("WebLogic Server 12.2.1.0.0 Tue Oct 6 10:05:47 PDT 2015 1721936 WebLogic JAX-RS 2.0 Portable Server / Jersey 2.x integration module");
        Assertions.assertThat((String)server.getVendor()).isEqualTo((Object)"WebLogic Server");
    }
}

