/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.filter.Filter;
import org.eximeebpms.bpm.engine.impl.TaskQueryImpl;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyFilterServiceTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String[] TENANT_IDS = new String[]{"tenant1", "tenant2"};
    protected String filterId = null;
    protected final List<String> taskIds = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        this.createTaskWithoutTenantId();
        this.createTaskForTenant(TENANT_ONE);
        this.createTaskForTenant(TENANT_TWO);
    }

    @Test
    public void testCreateFilterWithTenantIdCriteria() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(TENANT_IDS);
        this.filterId = this.createFilter(query);
        Filter savedFilter = this.filterService.getFilter(this.filterId);
        TaskQueryImpl savedQuery = (TaskQueryImpl)savedFilter.getQuery();
        Assertions.assertThat((Object[])savedQuery.getTenantIds()).isEqualTo((Object)TENANT_IDS);
    }

    @Test
    public void testCreateFilterWithNoTenantIdCriteria() {
        TaskQuery query = this.taskService.createTaskQuery().withoutTenantId();
        this.filterId = this.createFilter(query);
        Filter savedFilter = this.filterService.getFilter(this.filterId);
        TaskQueryImpl savedQuery = (TaskQueryImpl)savedFilter.getQuery();
        Assertions.assertThat((boolean)savedQuery.isWithoutTenantId()).isTrue();
        Assertions.assertThat((Object[])savedQuery.getTenantIds()).isNull();
    }

    @Test
    public void testFilterTasksNoTenantIdSet() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(3L);
    }

    @Test
    public void testFilterTasksByTenantIds() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(TENANT_IDS);
        this.filterId = this.createFilter(query);
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(2L);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("testTask");
        Assertions.assertThat((Long)this.filterService.count(this.filterId, (Query)extendingQuery)).isEqualTo(2L);
    }

    @Test
    public void testFilterTasksWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().withoutTenantId();
        this.filterId = this.createFilter(query);
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(1L);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("testTask");
        Assertions.assertThat((Long)this.filterService.count(this.filterId, (Query)extendingQuery)).isEqualTo(1L);
    }

    @Test
    public void testFilterTasksByExtendingQueryWithTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((Long)this.filterService.count(this.filterId, (Query)extendingQuery)).isEqualTo(1L);
    }

    @Test
    public void testFilterTasksByExtendingQueryWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().withoutTenantId();
        Assertions.assertThat((Long)this.filterService.count(this.filterId, (Query)extendingQuery)).isEqualTo(1L);
    }

    @Test
    public void testFilterTasksWithNoAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, null);
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(1L);
    }

    @Test
    public void testFilterTasksWithAuthenticatedTenant() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(2L);
    }

    @Test
    public void testFilterTasksWithAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(3L);
    }

    @Test
    public void testFilterTasksByTenantIdNoAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, null);
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(0L);
    }

    @Test
    public void testFilterTasksByTenantIdWithAuthenticatedTenant() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(1L);
    }

    @Test
    public void testFilterTasksByExtendingQueryWithTenantIdNoAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, null);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((Long)this.filterService.count(this.filterId, (Query)extendingQuery)).isEqualTo(0L);
    }

    @Test
    public void testFilterTasksByExtendingQueryWithTenantIdAuthenticatedTenant() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((Long)this.filterService.count(this.filterId, (Query)extendingQuery)).isEqualTo(1L);
    }

    @Test
    public void testFilterTasksWithDisabledTenantCheck() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        Assertions.assertThat((Long)this.filterService.count(this.filterId)).isEqualTo(3L);
    }

    protected void createTaskWithoutTenantId() {
        this.createTaskForTenant(null);
    }

    protected void createTaskForTenant(String tenantId) {
        Task newTask = this.taskService.newTask();
        newTask.setName("testTask");
        if (tenantId != null) {
            newTask.setTenantId(tenantId);
        }
        this.taskService.saveTask(newTask);
        this.taskIds.add(newTask.getId());
    }

    protected String createFilter(TaskQuery query) {
        Filter newFilter = this.filterService.newTaskFilter("myFilter");
        newFilter.setQuery((Query)query);
        return this.filterService.saveFilter(newFilter).getId();
    }

    @After
    public void tearDown() throws Exception {
        this.filterService.deleteFilter(this.filterId);
        this.identityService.clearAuthentication();
        for (String taskId : this.taskIds) {
            this.taskService.deleteTask(taskId, true);
        }
    }
}

