/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.cmmn;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyProcessTaskTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN_LATEST = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn";
    protected static final String CMMN_LATEST_WITH_MANUAL_ACTIVATION = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTaskWithManualActivation.cmmn";
    protected static final String CMMN_DEPLOYMENT = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTaskDeploymentBinding.cmmn";
    protected static final String CMMN_VERSION = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTaskVersionBinding.cmmn";
    protected static final String CMMN_VERSION_2 = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTaskVersionBinding_v2.cmmn";
    protected static final String CMMN_TENANT_CONST = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTaskTenantIdConst.cmmn";
    protected static final String CMMN_TENANT_EXPR = "org/eximeebpms/bpm/engine/test/api/multitenancy/CaseWithProcessTaskTenantIdExpr.cmmn";
    protected static final String PROCESS_TASK_ID = "PI_ProcessTask_1";
    protected static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();

    @Test
    public void testStartProcessInstanceWithDeploymentBinding() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS, CMMN_DEPLOYMENT);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS, CMMN_DEPLOYMENT);
        this.createCaseInstance("testCaseDeployment", TENANT_ONE);
        this.createCaseInstance("testCaseDeployment", TENANT_TWO);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithLatestBindingSameVersion() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS, CMMN_LATEST_WITH_MANUAL_ACTIVATION);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS, CMMN_LATEST_WITH_MANUAL_ACTIVATION);
        this.createCaseInstance("testCase", TENANT_ONE);
        this.createCaseInstance("testCase", TENANT_TWO);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithLatestBindingDifferentVersion() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS, CMMN_LATEST_WITH_MANUAL_ACTIVATION);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS, CMMN_LATEST_WITH_MANUAL_ACTIVATION);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.createCaseInstance("testCase", TENANT_ONE);
        this.createCaseInstance("testCase", TENANT_TWO);
        ProcessDefinition latestProcessTenantTwo = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).processDefinitionKey("testProcess").latestVersion().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).processDefinitionId(latestProcessTenantTwo.getId()).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithVersionBinding() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS, CMMN_VERSION);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS, CMMN_VERSION);
        this.createCaseInstance("testCaseVersion", TENANT_ONE);
        this.createCaseInstance("testCaseVersion", TENANT_TWO);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithDeploymentBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_DEPLOYMENT);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        try {
            this.createCaseInstance("testCaseDeployment", TENANT_ONE);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key = 'testProcess'"});
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithLatestBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_LATEST);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        try {
            this.createCaseInstance("testCase", TENANT_ONE);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key 'testProcess'"});
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithVersionBinding() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS, CMMN_VERSION_2);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        try {
            this.createCaseInstance("testCaseVersion", TENANT_ONE);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key = 'testProcess'"});
        }
    }

    @Test
    public void testProcessRefTenantIdConstant() {
        this.testRule.deploy(CMMN_TENANT_CONST);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.caseService.withCaseDefinitionByKey("testCase").create();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testProcessRefTenantIdExpression() {
        this.testRule.deploy(CMMN_TENANT_EXPR);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.caseService.withCaseDefinitionByKey("testCase").create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(PROCESS_TASK_ID).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    protected void createCaseInstance(String caseDefinitionKey, String tenantId) {
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).caseDefinitionTenantId(tenantId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(PROCESS_TASK_ID).tenantIdIn(new String[]{tenantId}).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
    }
}

