/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.cmmn.query.history;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricCaseActivityInstanceQueryTest {
    protected static final String CMMN_FILE = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected CaseService caseService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.caseService = this.engineRule.getCaseService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_NULL, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.createCaseInstance(TENANT_NULL);
        this.createCaseInstance(TENANT_ONE);
        this.createCaseInstance(TENANT_TWO);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricCaseActivityInstanceQuery queryTenantOne = this.historyService.createHistoricCaseActivityInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        HistoricCaseActivityInstanceQuery queryTenantTwo = this.historyService.createHistoricCaseActivityInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricCaseActivityInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicCaseActivityInstances = ((HistoricCaseActivityInstanceQuery)this.historyService.createHistoricCaseActivityInstanceQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicCaseActivityInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicCaseActivityInstances, TestOrderingUtil.historicCaseActivityInstanceByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicCaseActivityInstances = ((HistoricCaseActivityInstanceQuery)this.historyService.createHistoricCaseActivityInstanceQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicCaseActivityInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicCaseActivityInstances, TestOrderingUtil.inverted(TestOrderingUtil.historicCaseActivityInstanceByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected void createCaseInstance(String tenantId) {
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("oneTaskCase");
        builder.caseDefinitionTenantId(tenantId).create();
    }
}

