/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.BatchQuery;
import org.eximeebpms.bpm.engine.batch.BatchStatistics;
import org.eximeebpms.bpm.engine.batch.BatchStatisticsQuery;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyBatchQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain defaultRuleChin = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected BatchMigrationHelper batchHelper = new BatchMigrationHelper(this.engineRule);
    protected ManagementService managementService;
    protected IdentityService identityService;
    protected Batch sharedBatch;
    protected Batch tenant1Batch;
    protected Batch tenant2Batch;

    @Before
    public void initServices() {
        this.managementService = this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Before
    public void deployProcesses() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_TWO, ProcessModels.ONE_TASK_PROCESS);
        this.sharedBatch = this.batchHelper.migrateProcessInstanceAsync(sharedDefinition, sharedDefinition);
        this.tenant1Batch = this.batchHelper.migrateProcessInstanceAsync(tenant1Definition, tenant1Definition);
        this.tenant2Batch = this.batchHelper.migrateProcessInstanceAsync(tenant2Definition, tenant2Definition);
    }

    @After
    public void removeBatches() {
        this.batchHelper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testBatchQueryNoAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, null);
        List batches = this.managementService.createBatchQuery().list();
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertEquals((Object)this.sharedBatch.getId(), (Object)((Batch)batches.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createBatchQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testBatchQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        List batches = this.managementService.createBatchQuery().list();
        Assert.assertEquals((long)2L, (long)batches.size());
        this.assertBatches(batches, this.tenant1Batch.getId(), this.sharedBatch.getId());
        Assert.assertEquals((long)2L, (long)this.managementService.createBatchQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testBatchQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        List batches = this.managementService.createBatchQuery().list();
        Assert.assertEquals((long)3L, (long)batches.size());
        Assert.assertEquals((long)3L, (long)this.managementService.createBatchQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testBatchStatisticsNoAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, null);
        List statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        Assert.assertEquals((Object)this.sharedBatch.getId(), (Object)((BatchStatistics)statistics.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createBatchStatisticsQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testBatchStatisticsAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        List statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        Assert.assertEquals((long)2L, (long)this.managementService.createBatchStatisticsQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testBatchStatisticsAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        List statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)3L, (long)statistics.size());
        Assert.assertEquals((long)3L, (long)this.managementService.createBatchStatisticsQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testBatchQueryFilterByTenant() {
        Batch returnedBatch = (Batch)this.managementService.createBatchQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assert.assertNotNull((Object)returnedBatch);
        Assert.assertEquals((Object)this.tenant1Batch.getId(), (Object)returnedBatch.getId());
    }

    @Test
    public void testBatchQueryFilterByTenants() {
        List returnedBatches = ((BatchQuery)this.managementService.createBatchQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertEquals((long)2L, (long)returnedBatches.size());
        Assert.assertEquals((Object)this.tenant1Batch.getId(), (Object)((Batch)returnedBatches.get(0)).getId());
        Assert.assertEquals((Object)this.tenant2Batch.getId(), (Object)((Batch)returnedBatches.get(1)).getId());
    }

    @Test
    public void testBatchQueryFilterWithoutTenantId() {
        Batch returnedBatch = (Batch)this.managementService.createBatchQuery().withoutTenantId().singleResult();
        Assert.assertNotNull((Object)returnedBatch);
        Assert.assertEquals((Object)this.sharedBatch.getId(), (Object)returnedBatch.getId());
    }

    @Test
    public void testBatchQueryFailOnNullTenantIdCase1() {
        String[] tenantIds = null;
        try {
            this.managementService.createBatchQuery().tenantIdIn(tenantIds);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchQueryFailOnNullTenantIdCase2() {
        String[] tenantIds = new String[]{null};
        try {
            this.managementService.createBatchQuery().tenantIdIn(tenantIds);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testOrderByTenantIdAsc() {
        List orderedBatches = ((BatchQuery)this.managementService.createBatchQuery().orderByTenantId().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.batchByTenantId());
    }

    @Test
    public void testOrderByTenantIdDesc() {
        List orderedBatches = ((BatchQuery)this.managementService.createBatchQuery().orderByTenantId().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.batchByTenantId()));
    }

    @Test
    public void testBatchStatisticsQueryFilterByTenant() {
        BatchStatistics returnedBatch = (BatchStatistics)this.managementService.createBatchStatisticsQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assert.assertNotNull((Object)returnedBatch);
        Assert.assertEquals((Object)this.tenant1Batch.getId(), (Object)returnedBatch.getId());
    }

    @Test
    public void testBatchStatisticsQueryFilterByTenants() {
        List returnedBatches = ((BatchStatisticsQuery)this.managementService.createBatchStatisticsQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertEquals((long)2L, (long)returnedBatches.size());
        Assert.assertEquals((Object)this.tenant1Batch.getId(), (Object)((BatchStatistics)returnedBatches.get(0)).getId());
        Assert.assertEquals((Object)this.tenant2Batch.getId(), (Object)((BatchStatistics)returnedBatches.get(1)).getId());
    }

    @Test
    public void testBatchStatisticsQueryFilterWithoutTenantId() {
        BatchStatistics returnedBatch = (BatchStatistics)this.managementService.createBatchStatisticsQuery().withoutTenantId().singleResult();
        Assert.assertNotNull((Object)returnedBatch);
        Assert.assertEquals((Object)this.sharedBatch.getId(), (Object)returnedBatch.getId());
    }

    @Test
    public void testBatchStatisticsQueryFailOnNullTenantIdCase1() {
        String[] tenantIds = null;
        try {
            this.managementService.createBatchStatisticsQuery().tenantIdIn(tenantIds);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchStatisticsQueryFailOnNullTenantIdCase2() {
        String[] tenantIds = new String[]{null};
        try {
            this.managementService.createBatchStatisticsQuery().tenantIdIn(tenantIds);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchStatisticsQueryOrderByTenantIdAsc() {
        List orderedBatches = ((BatchStatisticsQuery)this.managementService.createBatchStatisticsQuery().orderByTenantId().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.batchStatisticsByTenantId());
    }

    @Test
    public void testBatchStatisticsQueryOrderByTenantIdDesc() {
        List orderedBatches = ((BatchStatisticsQuery)this.managementService.createBatchStatisticsQuery().orderByTenantId().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.batchStatisticsByTenantId()));
    }

    protected void assertBatches(List<? extends Batch> actualBatches, String ... expectedIds) {
        Assert.assertEquals((long)expectedIds.length, (long)actualBatches.size());
        HashSet<String> actualIds = new HashSet<String>();
        for (Batch batch : actualBatches) {
            actualIds.add(batch.getId());
        }
        for (String expectedId : expectedIds) {
            Assert.assertTrue((boolean)actualIds.contains(expectedId));
        }
    }
}

