/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query.history;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricDetailQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CamundaUserTaskFormFieldBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDetailFormPropertyQueryTest {
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws IOException {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.formService = this.engineRule.getFormService();
        this.identityService = this.engineRule.getIdentityService();
        BpmnModelInstance oneTaskProcess = ((UserTaskBuilder)((CamundaUserTaskFormFieldBuilder)((CamundaUserTaskFormFieldBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("userTask").camundaFormField().camundaId("myFormField")).camundaType("string")).camundaFormFieldDone()).endEvent().done();
        this.testRule.deployForTenant(TENANT_NULL, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_ONE, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, oneTaskProcess);
        ProcessInstance processInstanceNull = this.startProcessInstanceForTenant(TENANT_NULL);
        ProcessInstance processInstanceOne = this.startProcessInstanceForTenant(TENANT_ONE);
        ProcessInstance processInstanceTwo = this.startProcessInstanceForTenant(TENANT_TWO);
        this.completeUserTask(processInstanceNull);
        this.completeUserTask(processInstanceOne);
        this.completeUserTask(processInstanceTwo);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().withoutTenantId().formFields();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricDetailQuery queryTenantOne = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{TENANT_ONE});
        HistoricDetailQuery queryTenantTwo = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricDetailQuery().formFields().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formFields().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicDetails.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicDetails, TestOrderingUtil.historicDetailByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formFields().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicDetails.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicDetails, TestOrderingUtil.inverted(TestOrderingUtil.historicDetailByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }

    protected void completeUserTask(ProcessInstance processInstance) {
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("myFormField", "myFormFieldValue");
        this.formService.submitTaskForm(task.getId(), properties);
    }
}

