/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class MultiTenancyHistoricVariableInstanceQueryTest {
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String TENANT_NULL_VAR = "tenantNullVar";
    protected static final String TENANT_ONE_VAR = "tenant1Var";
    protected static final String TENANT_TWO_VAR = "tenant2Var";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().endEvent().done();
        this.testRule.deployForTenant(TENANT_NULL, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_ONE, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, oneTaskProcess);
        this.startProcessInstanceForTenant(TENANT_NULL, TENANT_NULL_VAR);
        this.startProcessInstanceForTenant(TENANT_ONE, TENANT_ONE_VAR);
        this.startProcessInstanceForTenant(TENANT_TWO, TENANT_TWO_VAR);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricVariableInstanceQuery queryTenantOne = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        HistoricVariableInstanceQuery queryTenantTwo = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(1L);
        Assertions.assertThat((Object)((HistoricVariableInstance)queryTenantOne.list().get(0)).getValue()).isEqualTo((Object)TENANT_ONE_VAR);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(1L);
        Assertions.assertThat((Object)((HistoricVariableInstance)queryTenantTwo.list().get(0)).getValue()).isEqualTo((Object)TENANT_TWO_VAR);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicVariableInstances = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicVariableInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicVariableInstances, TestOrderingUtil.historicVariableInstanceByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicVariableInstances = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicVariableInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicVariableInstances, TestOrderingUtil.inverted(TestOrderingUtil.historicVariableInstanceByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant, String var) {
        return ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").setVariable("myVar", (Object)var)).processDefinitionTenantId(tenant).execute();
    }
}

