/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.optimize;

import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.OptimizeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetRunningHistoricTaskInstancesForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;
    private HistoryService historyService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        for (HistoricTaskInstance task : this.historyService.createHistoricTaskInstanceQuery().list()) {
            this.historyService.deleteHistoricTaskInstance(task.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getRunningHistoricTaskInstances() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).camundaAssignee(this.userId)).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(null, null, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatTasksHaveAllImportantInformation((HistoricTaskInstance)runningHistoricTaskInstances.get(0));
    }

    @Test
    public void startedAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(now, null, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)runningHistoricTaskInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance2.getId()));
    }

    @Test
    public void startedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(null, now, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)runningHistoricTaskInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance1.getId()));
    }

    @Test
    public void startedAfterAndFinishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(now, now, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByStartTime() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        ProcessInstance processInstance3 = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)runningHistoricTaskInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance1.getId()));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)runningHistoricTaskInstances.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance2.getId()));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)runningHistoricTaskInstances.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance3.getId()));
    }

    @Test
    public void fetchOnlyRunningTasks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask1").userTask("userTask2").userTask("userTask3").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)runningHistoricTaskInstances.get(0)).getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask2"));
    }

    @Test
    public void doNotReturnRunningStandaloneTasks() {
        try {
            Task task = this.taskService.newTask("standaloneTaskId");
            this.taskService.saveTask(task);
            List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(null, null, 10);
            Assert.assertTrue((boolean)runningHistoricTaskInstances.isEmpty());
        }
        finally {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.deleteTask(task.getId());
            }
        }
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatTasksHaveAllImportantInformation(HistoricTaskInstance completedHistoricTaskInstance) {
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getName(), (Matcher)CoreMatchers.is((Object)"task"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getStartTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getEndTime(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getAssignee(), (Matcher)CoreMatchers.is((Object)this.userId));
    }
}

