/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.queries;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.cfg.IdGenerator;
import org.eximeebpms.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class QueryByIdAfterTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> config.setIdGenerator((IdGenerator)new StrongUuidGenerator()));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private HistoryService historyService;
    private RuntimeService runtimeService;

    private static boolean isIdGreaterThan(String id1, String id2) {
        return id1.compareTo(id2) > 0;
    }

    @Before
    public void init() {
        this.historyService = this.engineRule.getProcessEngine().getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testSimple.bpmn20.xml"})
    public void shouldVariableInstanceApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("myProc", 10);
        HistoricVariableInstanceQueryImpl historicVariableInstanceQuery = (HistoricVariableInstanceQueryImpl)this.historyService.createHistoricVariableInstanceQuery();
        List historicVariableInstances = ((HistoricVariableInstanceQuery)historicVariableInstanceQuery.orderByVariableId().asc()).list();
        String firstId = ((HistoricVariableInstance)historicVariableInstances.get(0)).getId();
        String middleId = ((HistoricVariableInstance)historicVariableInstances.get(9)).getId();
        String lastId = ((HistoricVariableInstance)historicVariableInstances.get(historicVariableInstances.size() - 1)).getId();
        Assert.assertEquals((long)20L, (long)historicVariableInstances.size());
        Assert.assertEquals((long)19L, (long)historicVariableInstanceQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)historicVariableInstanceQuery.idAfter(lastId).list().size());
        List secondHalf = historicVariableInstanceQuery.idAfter(middleId).list();
        Assert.assertEquals((long)10L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(variable -> QueryByIdAfterTest.isIdGreaterThan(variable.getId(), middleId)));
    }

    private void startProcessInstancesByKey(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            Map<String, CallSite> variables = Collections.singletonMap("message", "exception" + i);
            this.runtimeService.startProcessInstanceByKey(key, "" + i, variables);
        }
        this.testRule.executeAvailableJobs();
    }
}

