/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.management.ActivityStatistics;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.TransitionInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionTree;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceModificationAsyncTest
extends PluggableProcessEngineTest {
    protected static final String EXCLUSIVE_GATEWAY_ASYNC_BEFORE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";
    protected static final String ASYNC_BEFORE_ONE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneTaskProcess.bpmn20.xml";
    protected static final String ASYNC_BEFORE_ONE_SCOPE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_BEFORE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_BEFORE_SCOPE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_PARALLEL_ASYNC_BEFORE_SCOPE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_BEFORE_IO_LISTENER_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcessIoAndListeners.bpmn20.xml";
    protected static final String ASYNC_AFTER_ONE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_AFTER_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_AFTER_END_EVENT_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterEndEventProcess.bpmn20.xml";
    protected static final String ASYNC_AFTER_FAILING_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterFailingTaskProcess.bpmn20.xml";
    protected static final String ASYNC_BEFORE_FAILING_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeFailingTaskProcess.bpmn20.xml";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    @Test
    public void testStartBeforeAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNull((Object)task);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").transition("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.testRule.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testStartAfterAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Execution jobExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("end2").executionId(job.getExecutionId()).singleResult();
        Assert.assertNotNull((Object)jobExecution);
        this.completeTasksInOrder("task1");
        this.managementService.executeJob(job.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelParentScopeOfAsyncBeforeActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelParentScopeOfAsyncBeforeScopeActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelParentScopeOfParallelAsyncBeforeScopeActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedConcurrentTasksProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncActivityInstanceFails() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("activityInstance is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncBeforeTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncBeforeTransitionInstanceEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncBeforeScopeTransitionInstanceEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAndStartAsyncBeforeTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Job asyncJob = (Job)this.managementService.createJobQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).startBeforeActivity("theTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theTask").done());
        Job newAsyncJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertFalse((boolean)asyncJob.getId().equals(newAsyncJob.getId()));
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        this.testRule.executeAvailableJobs();
        this.completeTasksInOrder("theTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelNestedConcurrentTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedConcurrentTasksProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask1").getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").transition("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        Job innerTask2Job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)innerTask2Job);
        Execution innerTask2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask2").singleResult();
        Assert.assertNotNull((Object)innerTask2Execution);
        Assert.assertEquals((Object)innerTask2Job.getExecutionId(), (Object)innerTask2Execution.getId());
        this.completeTasksInOrder("outerTask");
        this.managementService.executeJob(innerTask2Job.getId());
        this.completeTasksInOrder("innerTask2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelNestedConcurrentTransitionInstanceWithConcurrentScopeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedConcurrentTasksProcess");
        String processInstanceId = processInstance.getId();
        Job innerTask2Job = (Job)this.managementService.createJobQuery().activityId("innerTask2").singleResult();
        Assert.assertNotNull((Object)innerTask2Job);
        this.managementService.executeJob(innerTask2Job.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask1").getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask2").scope().done());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().activityId("innerTask1").count());
        this.completeTasksInOrder("innerTask2", "outerTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcessIoAndListeners.bpmn20.xml"})
    @Test
    public void testCancelTransitionInstanceShouldNotInvokeIoMappingAndListenersOfTargetActivity() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("outputMappingExecuted").count());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncAfterTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)innerTask);
        this.taskService.complete(innerTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterEndEventProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncAfterEndEventTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedAsyncEndEventProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "subProcessEnd").getId()).execute();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAsyncAfterTransitionInstanceEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCancelAsyncAfterTransitionInstanceInvokesParentListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "subProcessEnd").getId()).execute();
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent event = RecorderExecutionListener.getRecordedEvents().get(0);
        Assert.assertEquals((Object)"subProcess", (Object)event.getActivityId());
        RecorderExecutionListener.clear();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAllCancelsTransitionInstances() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("innerTask").execute();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterFailingTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingAfterAsyncTask");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("task1").transition("task1").done());
        this.testRule.executeAvailableJobs();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("task1").transition("task1").done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterFailingTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeAsyncAfterTaskActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingAfterAsyncTask");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        Assert.assertEquals((Object)"task1", (Object)((ActivityStatistics)statistics.get(0)).getId());
        Assert.assertEquals((long)0L, (long)((ActivityStatistics)statistics.get(0)).getFailedJobs());
        Assert.assertEquals((long)0L, (long)((ActivityStatistics)statistics.get(0)).getIncidentStatistics().size());
        Assert.assertEquals((long)1L, (long)((ActivityStatistics)statistics.get(0)).getInstances());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).execute();
        statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        Assert.assertEquals((Object)"task1", (Object)((ActivityStatistics)statistics.get(0)).getId());
        Assert.assertEquals((long)0L, (long)((ActivityStatistics)statistics.get(0)).getFailedJobs());
        Assert.assertEquals((long)0L, (long)((ActivityStatistics)statistics.get(0)).getIncidentStatistics().size());
        Assert.assertEquals((long)2L, (long)((ActivityStatistics)statistics.get(0)).getInstances());
        this.testRule.executeAvailableJobs();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAllTransitionInstanceInScope() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedOneTaskProcess").startBeforeActivity("innerTask")).startBeforeActivity("innerTask")).startBeforeActivity("outerTask")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] transitionInstances = tree.getTransitionInstances("innerTask");
        this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance(transitionInstances[0].getId()).cancelTransitionInstance(transitionInstances[1].getId()).execute();
        tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelTransitionInstanceTwiceFails() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedOneTaskProcess").startBeforeActivity("innerTask")).startBeforeActivity("innerTask")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] transitionInstances = tree.getTransitionInstances("innerTask");
        String transitionInstanceId = transitionInstances[0].getId();
        try {
            this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance(transitionInstanceId).cancelTransitionInstance(transitionInstanceId).execute();
            Assert.fail((String)"should not be possible to cancel the first instance twice");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("Cannot perform instruction: Cancel transition instance '" + transitionInstanceId + "'; Transition instance '" + transitionInstanceId + "' does not exist: transitionInstance is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelTransitionInstanceTwiceFailsCase2() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedOneTaskProcess").startBeforeActivity("innerTask")).startBeforeActivity("innerTask")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] transitionInstances = tree.getTransitionInstances("innerTask");
        try {
            ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance(transitionInstances[0].getId()).startBeforeActivity("innerTask")).startBeforeActivity("innerTask")).cancelTransitionInstance(transitionInstances[1].getId()).cancelTransitionInstance(transitionInstances[1].getId()).execute();
            Assert.fail((String)"should not be possible to cancel the first instance twice");
        }
        catch (NotValidException e) {
            String transitionInstanceId = transitionInstances[1].getId();
            this.testRule.assertTextPresentIgnoreCase("Cannot perform instruction: Cancel transition instance '" + transitionInstanceId + "'; Transition instance '" + transitionInstanceId + "' does not exist: transitionInstance is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelStartCancelInScope() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedConcurrentTasksProcess").startBeforeActivity("innerTask1")).startBeforeActivity("innerTask1")).startBeforeActivity("outerTask")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] transitionInstances = tree.getTransitionInstances("innerTask1");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance(transitionInstances[0].getId()).startBeforeActivity("innerTask2")).cancelTransitionInstance(transitionInstances[1].getId()).execute();
        tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").transition("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testStartAndCancelAllForTransitionInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedConcurrentTasksProcess").startBeforeActivity("innerTask1")).startBeforeActivity("innerTask1")).startBeforeActivity("innerTask1")).execute();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("innerTask2")).cancelAllForActivity("innerTask1").execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").transition("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("innerTask2").scope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testRepeatedStartAndCancellationForTransitionInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedConcurrentTasksProcess").startBeforeActivity("innerTask1")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance transitionInstance = tree.getTransitionInstances("innerTask1")[0];
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("innerTask2")).cancelAllForActivity("innerTask2").startBeforeActivity("innerTask2")).cancelAllForActivity("innerTask2").startBeforeActivity("innerTask2")).cancelAllForActivity("innerTask2").cancelTransitionInstance(transitionInstance.getId()).execute();
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testRepeatedCancellationAndStartForTransitionInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedConcurrentTasksProcess").startBeforeActivity("innerTask1")).startBeforeActivity("innerTask1")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] transitionInstances = tree.getTransitionInstances("innerTask1");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance(transitionInstances[0].getId()).startBeforeActivity("innerTask2")).cancelAllForActivity("innerTask2").startBeforeActivity("innerTask2")).cancelAllForActivity("innerTask2").startBeforeActivity("innerTask2")).cancelTransitionInstance(transitionInstances[1].getId()).execute();
        tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").transition("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("innerTask2").scope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeAndCancelSingleTransitionInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedConcurrentTasksProcess").startBeforeActivity("innerTask1")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance transitionInstance = tree.getTransitionInstances("innerTask1")[0];
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("innerTask2")).cancelTransitionInstance(transitionInstance.getId()).execute();
        tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").transition("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("innerTask2").scope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeSyncEndAndCancelSingleTransitionInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("nestedConcurrentTasksProcess").startBeforeActivity("outerTask")).startBeforeActivity("innerTask1")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance transitionInstance = tree.getTransitionInstances("innerTask1")[0];
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("subProcessEnd2")).cancelTransitionInstance(transitionInstance.getId()).execute();
        tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeFailingTaskProcess.bpmn20.xml"})
    @Test
    public void testRestartAFailedServiceTask() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("failingAfterBeforeTask").startBeforeActivity("task2")).execute();
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task2")).cancelTransitionInstance(tree.getTransitionInstances("task2")[0].getId()).execute();
        this.testRule.executeAvailableJobs();
        Incident newIncident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)newIncident);
        Assert.assertNotSame((Object)incident.getId(), (Object)newIncident.getId());
    }

    protected String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected TransitionInstance getChildTransitionInstanceForTargetActivity(ActivityInstance activityInstance, String targetActivityId) {
        for (TransitionInstance transitionInstance : activityInstance.getChildTransitionInstances()) {
            if (!targetActivityId.equals(transitionInstance.getActivityId())) continue;
            return transitionInstance;
        }
        for (TransitionInstance transitionInstance : activityInstance.getChildActivityInstances()) {
            TransitionInstance instance = this.getChildTransitionInstanceForTargetActivity((ActivityInstance)transitionInstance, targetActivityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

