/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.BatchSuspensionHelper;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UpdateProcessInstancesSuspendStateAsyncTest {
    protected static final Date TEST_DATE = new Date(1457326800000L);
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSuspensionHelper helper = new BatchSuspensionHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionById() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    public void testBatchSuspensionByIdsInDifferentDeployments() {
        String deploymentId1 = this.testRule.deployAndGetDefinition("org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").getDeploymentId();
        String deploymentId2 = this.testRule.deployAndGetDefinition("org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml").getDeploymentId();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        Job seedJob = this.helper.getSeedJob(suspendprocess);
        Assertions.assertThat((String)seedJob.getDeploymentId()).isIn(new Object[]{deploymentId1, deploymentId2});
        this.helper.completeSeedJobs(suspendprocess);
        List<Job> batchJobs = this.helper.getExecutionJobs(suspendprocess);
        Assertions.assertThat(batchJobs).hasSize(2);
        Assertions.assertThat((String)batchJobs.get(0).getDeploymentId()).isIn(new Object[]{deploymentId1, deploymentId2});
        Assertions.assertThat((String)batchJobs.get(1).getDeploymentId()).isIn(new Object[]{deploymentId1, deploymentId2});
        Assertions.assertThat((String)batchJobs.get(0).getDeploymentId()).isNotEqualTo((Object)batchJobs.get(1).getDeploymentId());
        this.helper.completeExecutionJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void shouldSetInvocationsPerBatchTypeOnSuspension() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("instance-update-suspension-state", 42);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch batch = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void shouldSetInvocationsPerBatchTypeOnActivation() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("instance-update-suspension-state", 42);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch batch = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).activateAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivationById() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Batch activateprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).activateAsync();
        this.helper.completeSeedJobs(activateprocess);
        this.helper.executeJobs(activateprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionByProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivationByProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Batch activateprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().suspended()).activateAsync();
        this.helper.completeSeedJobs(activateprocess);
        this.helper.executeJobs(activateprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="activity")
    public void testBatchSuspensionByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="activity")
    public void testBatchActivationByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Batch activateprocess = this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).activateAsync();
        this.helper.completeSeedJobs(activateprocess);
        this.helper.executeJobs(activateprocess);
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    public void testEmptyProcessInstanceListSuspendAsync() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[0]).suspendAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No process instance ids given");
    }

    @Test
    public void testEmptyProcessInstanceListActivateAsync() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[0]).activateAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No process instance ids given");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testNullProcessInstanceListActivateAsync() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId(), null)).activateAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot be null");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testNullProcessInstanceListSuspendAsync() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId(), null)).suspendAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot be null");
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldSetExecutionStartTimeInBatchAndHistory() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        this.testRule.deployAndGetDefinition("org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").getDeploymentId();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        Batch batch = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[]{processInstance1.getId()}).suspendAsync();
        this.helper.executeSeedJob(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch);
        this.helper.executeJob(executionJobs.get(0));
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        Assertions.assertThat((Date)batch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        Assertions.assertThat((Date)historicBatch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
    }
}

