/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.Arrays;
import java.util.Collection;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.BpmnEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.ConditionalEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MessageEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MigratingBpmnEventTrigger;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.SignalEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.TimerEventFactory;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MigrationBoundaryEventsParameterizedTest {
    public static final String AFTER_BOUNDARY_TASK = "afterBoundary";
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    public static final String NEW_TIMER_DATE = "2018-02-11T12:13:14Z";
    protected static final String BOUNDARY_ID = "boundary";
    protected static final String MIGRATE_MESSAGE_BOUNDARY_EVENT = "MigrateMessageBoundaryEvent";
    protected static final String MIGRATE_SIGNAL_BOUNDARY_EVENT = "MigrateSignalBoundaryEvent";
    protected static final String MIGRATE_TIMER_BOUNDARY_EVENT = "MigrateTimerBoundaryEvent";
    protected static final String MIGRATE_CONDITIONAL_BOUNDARY_EVENT = "MigrateConditionalBoundaryEvent";
    protected static final String USER_TASK_ID = "userTask";
    protected static final String NEW_BOUNDARY_ID = "newBoundary";
    public static final String USER_TASK_1_ID = "userTask1";
    public static final String USER_TASK_2_ID = "userTask2";
    public static final String SUB_PROCESS_ID = "subProcess";
    @Parameterized.Parameter
    public BpmnEventFactory eventFactory;
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new TimerEventFactory()}, {new MessageEventFactory()}, {new SignalEventFactory()}, {new ConditionalEventFactory()});
    }

    @Test
    public void testMigrateBoundaryEventOnUserTask() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, USER_TASK_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, NEW_BOUNDARY_ID);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventOnUserTaskAndTriggerEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, USER_TASK_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.inContextOf(NEW_BOUNDARY_ID).trigger(processInstance.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventOnConcurrentUserTask() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_GATEWAY_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, USER_TASK_1_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_1_ID, USER_TASK_1_ID).mapActivities(USER_TASK_2_ID, USER_TASK_2_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, NEW_BOUNDARY_ID);
        this.testHelper.completeTask(USER_TASK_1_ID);
        this.testHelper.completeTask(USER_TASK_2_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventOnConcurrentUserTaskAndTriggerEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_GATEWAY_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, USER_TASK_1_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_1_ID, USER_TASK_1_ID).mapActivities(USER_TASK_2_ID, USER_TASK_2_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.inContextOf(NEW_BOUNDARY_ID).trigger(processInstance.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask(USER_TASK_2_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventOnConcurrentScopeUserTask() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_SCOPE_TASKS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, USER_TASK_1_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_1_ID, USER_TASK_1_ID).mapActivities(USER_TASK_2_ID, USER_TASK_2_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, NEW_BOUNDARY_ID);
        this.testHelper.completeTask(USER_TASK_1_ID);
        this.testHelper.completeTask(USER_TASK_2_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventOnConcurrentScopeUserTaskAndTriggerEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_SCOPE_TASKS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, USER_TASK_1_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_1_ID, USER_TASK_1_ID).mapActivities(USER_TASK_2_ID, USER_TASK_2_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.inContextOf(NEW_BOUNDARY_ID).trigger(processInstance.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask(USER_TASK_2_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventToSubProcess() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, SUB_PROCESS_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(SUB_PROCESS_ID, SUB_PROCESS_ID).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, NEW_BOUNDARY_ID);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventToSubProcessAndTriggerEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, SUB_PROCESS_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(SUB_PROCESS_ID, SUB_PROCESS_ID).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.inContextOf(NEW_BOUNDARY_ID).trigger(processInstance.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventToSubProcessWithScopeUserTask() {
        BpmnModelInstance sourceProcess = ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, SUB_PROCESS_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(SUB_PROCESS_ID, SUB_PROCESS_ID).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, NEW_BOUNDARY_ID);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventToSubProcessWithScopeUserTaskAndTriggerEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, SUB_PROCESS_ID, BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(SUB_PROCESS_ID, SUB_PROCESS_ID).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.inContextOf(NEW_BOUNDARY_ID).trigger(processInstance.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventToParallelSubProcess() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_SUBPROCESS_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, "subProcess1", BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities(USER_TASK_1_ID, USER_TASK_1_ID).mapActivities("subProcess2", "subProcess2").mapActivities(USER_TASK_2_ID, USER_TASK_2_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, NEW_BOUNDARY_ID);
        this.testHelper.completeTask(USER_TASK_1_ID);
        this.testHelper.completeTask(USER_TASK_2_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventToParallelSubProcessAndTriggerEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_SUBPROCESS_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addBoundaryEvent(this.rule.getProcessEngine(), sourceProcess, "subProcess1", BOUNDARY_ID);
        ModifiableBpmnModelInstance.wrap(sourceProcess).flowNodeBuilder(BOUNDARY_ID).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId(BOUNDARY_ID, NEW_BOUNDARY_ID);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities(USER_TASK_1_ID, USER_TASK_1_ID).mapActivities("subProcess2", "subProcess2").mapActivities(USER_TASK_2_ID, USER_TASK_2_ID).mapActivities(BOUNDARY_ID, NEW_BOUNDARY_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        eventTrigger.inContextOf(NEW_BOUNDARY_ID).trigger(processInstance.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask(USER_TASK_2_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

