/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationCompensationAddRemoveSubProcessTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateCompensationSubscriptionAddRemoveSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateCompensationSubscriptionAddRemoveSubProcessAssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("subProcess").activity("compensationHandler").done());
    }

    @Test
    public void testMigrateCompensationSubscriptionAddRemoveSubProcessAssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("subProcess").scope().eventScope().done());
    }
}

