/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.migration.MigrationPlanValidationException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.GatewayModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationGatewayTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testParallelGatewayContinueExecution() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getTaskService().createTaskQuery().taskDefinitionKey("afterJoin").count());
        this.testHelper.completeTask("parallel1");
        this.testHelper.completeTask("afterJoin");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testParallelGatewayAssertTrees() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("parallel1").noScope().concurrent().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("parallel1")).up().child("join").noScope().concurrent().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("join")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("parallel1", this.testHelper.getSingleActivityInstanceBeforeMigration("parallel1").getId()).activity("join", this.testHelper.getSingleActivityInstanceBeforeMigration("join").getId()).done());
    }

    @Test
    public void testParallelGatewayAddScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW_IN_SUBPROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getTaskService().createTaskQuery().taskDefinitionKey("afterJoin").count());
        this.testHelper.completeTask("parallel1");
        this.testHelper.completeTask("afterJoin");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testInclusiveGatewayContinueExecution() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getTaskService().createTaskQuery().taskDefinitionKey("afterJoin").count());
        this.testHelper.completeTask("parallel1");
        this.testHelper.completeTask("afterJoin");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testInclusiveGatewayAssertTrees() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("parallel1").noScope().concurrent().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("parallel1")).up().child("join").noScope().concurrent().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("join")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("parallel1", this.testHelper.getSingleActivityInstanceBeforeMigration("parallel1").getId()).activity("join", this.testHelper.getSingleActivityInstanceBeforeMigration("join").getId()).done());
    }

    @Test
    public void testInclusiveGatewayAddScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW_IN_SUBPROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getTaskService().createTaskQuery().taskDefinitionKey("afterJoin").count());
        this.testHelper.completeTask("parallel1");
        this.testHelper.completeTask("afterJoin");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCannotMigrateParallelToInclusiveGateway() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("join", "join").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("join", "Activities have incompatible types (ParallelGatewayActivityBehavior is not compatible with InclusiveGatewayActivityBehavior)");
        }
    }

    @Test
    public void testCannotMigrateInclusiveToParallelGateway() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.INCLUSIVE_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("join", "join").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("join", "Activities have incompatible types (InclusiveGatewayActivityBehavior is not compatible with ParallelGatewayActivityBehavior)");
        }
    }

    @Test
    public void testCannotRemoveGatewayIncomingSequenceFlow() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(GatewayModels.PARALLEL_GW).removeFlowNode("parallel2"));
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("join", "join").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("join", "The target gateway must have at least the same number of incoming sequence flows that the source gateway has");
        }
    }

    @Test
    public void testAddGatewayIncomingSequenceFlow() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(GatewayModels.PARALLEL_GW).flowNodeBuilder("fork").userTask("parallel3").connectTo("join").done());
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("parallel2");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("parallel1", "parallel1").mapActivities("join", "join").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getTaskService().createTaskQuery().taskDefinitionKey("afterJoin").count());
        ((ProcessInstanceModificationInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceModification(processInstance.getId()).startBeforeActivity("join")).execute();
        Assert.assertEquals((long)0L, (long)this.rule.getTaskService().createTaskQuery().taskDefinitionKey("afterJoin").count());
        this.testHelper.completeTask("parallel1");
        this.testHelper.completeTask("afterJoin");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCannotRemoveParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW_IN_SUBPROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("join", "join").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("join", "The gateway's flow scope 'subProcess' must be mapped");
        }
    }

    @Test
    public void testCannotMapMultipleGatewaysToOne() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(GatewayModels.PARALLEL_GW);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("join", "join").mapActivities("fork", "join").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("join", "Only one gateway can be mapped to gateway 'join'");
        }
    }
}

