/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SetVariablesMigrationTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @After
    public void clearAuthentication() {
        this.rule.getIdentityService().clearAuthentication();
    }

    @After
    public void resetEngineConfig() {
        this.rule.getProcessEngineConfiguration().setRestrictUserOperationLogToAuthenticatedUsers(true);
    }

    @Test
    public void shouldSetVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(Collections.singletonMap("foo", "bar")).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", processInstance.getId()})});
    }

    @Test
    public void shouldSetVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("foo", "bar");
        variables.put("bar", 5);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(variables).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", processInstance.getId()}), Tuple.tuple((Object[])new Object[]{"bar", 5, processInstance.getId()})});
    }

    @Test
    public void shouldSetUntypedVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar")).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", processInstance.getId()})});
    }

    @Test
    public void shouldSetUntypedVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)5)).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", processInstance.getId()}), Tuple.tuple((Object[])new Object[]{"bar", 5, processInstance.getId()})});
    }

    @Test
    public void shouldSetMapOfTypedVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(Collections.singletonMap("foo", Variables.shortValue((Short)5))).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", (short)5, processInstance.getId()})});
    }

    @Test
    public void shouldSetVariableMapOfTypedVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValueTyped((String)"foo", (TypedValue)Variables.stringValue((String)"bar"))).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", processInstance.getId()})});
    }

    @Test
    public void shouldSetTypedAndUntypedVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar").putValueTyped("bar", (TypedValue)Variables.integerValue((Integer)5))).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).extracting(new String[]{"name", "value", "executionId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", processInstance.getId()}), Tuple.tuple((Object[])new Object[]{"bar", 5, processInstance.getId()})});
    }

    @Test
    public void shouldSetNullVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(null).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).isEmpty();
    }

    @Test
    public void shouldSetEmptyVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(new HashMap()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).isEmpty();
    }

    @Test
    public void shouldSetTransientVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").camundaExecutionListenerClass("end", ReadTransientVariableExecutionListener.class).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValueTyped((String)"foo", (TypedValue)Variables.stringValue((String)"bar", (boolean)true))).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat(this.testHelper.snapshotBeforeMigration.getVariables()).isEmpty();
        Assertions.assertThat(this.testHelper.snapshotAfterMigration.getVariables()).isEmpty();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldWriteOperationLog() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar").putValueTyped("bar", (TypedValue)Variables.integerValue((Integer)5))).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getIdentityService().setAuthenticatedUserId("user");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List operationLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assertions.assertThat((List)operationLogEntries).extracting(new String[]{"operationType", "userId", "property", "newValue"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"Migrate", "user", "processDefinitionId", targetProcessDefinition.getId()}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfInstances", "1"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfSetVariables", "2"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "async", "false"})});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldWriteOperationLogUnauthenticated() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar").putValueTyped("bar", (TypedValue)Variables.integerValue((Integer)5))).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getProcessEngineConfiguration().setRestrictUserOperationLogToAuthenticatedUsers(false);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List operationLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assertions.assertThat((List)operationLogEntries).extracting(new String[]{"operationType", "userId", "property", "newValue"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"Migrate", null, "processDefinitionId", targetProcessDefinition.getId()}), Tuple.tuple((Object[])new Object[]{"Migrate", null, "nrOfInstances", "1"}), Tuple.tuple((Object[])new Object[]{"Migrate", null, "nrOfSetVariables", "2"}), Tuple.tuple((Object[])new Object[]{"Migrate", null, "async", "false"})});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldWriteOperationLogForEmptyVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(new HashMap()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getIdentityService().setAuthenticatedUserId("user");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List operationLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assertions.assertThat((List)operationLogEntries).extracting(new String[]{"operationType", "userId", "property", "newValue"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"Migrate", "user", "processDefinitionId", targetProcessDefinition.getId()}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfInstances", "1"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfSetVariables", "0"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "async", "false"})});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldNotWriteOperationLogForVariablesNull() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getIdentityService().setAuthenticatedUserId("user");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List operationLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assertions.assertThat((List)operationLogEntries).extracting(new String[]{"operationType", "userId", "property", "newValue"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"Migrate", "user", "processDefinitionId", targetProcessDefinition.getId()}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfInstances", "1"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "async", "false"})});
    }

    public static class ReadTransientVariableExecutionListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            Object variable = execution.getVariable("foo");
            Assert.assertNotNull((Object)variable);
        }
    }
}

