/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration.util;

import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.BpmnEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MigratingBpmnEventTrigger;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;

public class ConditionalEventFactory
implements BpmnEventFactory {
    protected static final String VAR_CONDITION = "${any=='any'}";

    @Override
    public MigratingBpmnEventTrigger addBoundaryEvent(ProcessEngine engine, BpmnModelInstance modelInstance, String activityId, String boundaryEventId) {
        ((BoundaryEventBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).activityBuilder(activityId).boundaryEvent(boundaryEventId).condition(VAR_CONDITION)).done();
        ConditionalEventTrigger trigger = new ConditionalEventTrigger();
        trigger.engine = engine;
        trigger.variableName = "any";
        trigger.variableValue = "any";
        trigger.activityId = boundaryEventId;
        return trigger;
    }

    @Override
    public MigratingBpmnEventTrigger addEventSubProcess(ProcessEngine engine, BpmnModelInstance modelInstance, String parentId, String subProcessId, String startEventId) {
        ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).addSubProcessTo(parentId).id(subProcessId)).triggerByEvent()).embeddedSubProcess().startEvent(startEventId).condition(VAR_CONDITION)).subProcessDone().done();
        ConditionalEventTrigger trigger = new ConditionalEventTrigger();
        trigger.engine = engine;
        trigger.variableName = "any";
        trigger.variableValue = "any";
        trigger.activityId = startEventId;
        return trigger;
    }

    protected static class ConditionalEventTrigger
    implements MigratingBpmnEventTrigger {
        protected ProcessEngine engine;
        protected String variableName;
        protected Object variableValue;
        protected String activityId;

        protected ConditionalEventTrigger() {
        }

        @Override
        public void trigger(String processInstanceId) {
            this.engine.getRuntimeService().setVariable(processInstanceId, this.variableName, this.variableValue);
        }

        @Override
        public void assertEventTriggerMigrated(MigrationTestRule migrationContext, String targetActivityId) {
            migrationContext.assertEventSubscriptionMigrated(this.activityId, targetActivityId, null);
        }

        @Override
        public MigratingBpmnEventTrigger inContextOf(String newActivityId) {
            ConditionalEventTrigger newTrigger = new ConditionalEventTrigger();
            newTrigger.activityId = newActivityId;
            newTrigger.engine = this.engine;
            newTrigger.variableName = this.variableName;
            newTrigger.variableValue = this.variableValue;
            return newTrigger;
        }
    }
}

