/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.task;

import java.util.HashSet;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class SubTaskTest
extends PluggableProcessEngineTest {
    @Test
    public void testSubTask() {
        Task gonzoTask = this.taskService.newTask();
        gonzoTask.setName("gonzoTask");
        this.taskService.saveTask(gonzoTask);
        Task subTaskOne = this.taskService.newTask();
        subTaskOne.setName("subtask one");
        String gonzoTaskId = gonzoTask.getId();
        subTaskOne.setParentTaskId(gonzoTaskId);
        this.taskService.saveTask(subTaskOne);
        Task subTaskTwo = this.taskService.newTask();
        subTaskTwo.setName("subtask two");
        subTaskTwo.setParentTaskId(gonzoTaskId);
        this.taskService.saveTask(subTaskTwo);
        String subTaskId = subTaskOne.getId();
        Assert.assertTrue((boolean)this.taskService.getSubTasks(subTaskId).isEmpty());
        Assert.assertTrue((boolean)this.historyService.createHistoricTaskInstanceQuery().taskParentTaskId(subTaskId).list().isEmpty());
        List subTasks = this.taskService.getSubTasks(gonzoTaskId);
        HashSet<String> subTaskNames = new HashSet<String>();
        for (Task subTask : subTasks) {
            subTaskNames.add(subTask.getName());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_AUDIT.getId()) {
            HashSet<String> expectedSubTaskNames = new HashSet<String>();
            expectedSubTaskNames.add("subtask one");
            expectedSubTaskNames.add("subtask two");
            Assert.assertEquals(expectedSubTaskNames, subTaskNames);
            List historicSubTasks = this.historyService.createHistoricTaskInstanceQuery().taskParentTaskId(gonzoTaskId).list();
            subTaskNames = new HashSet();
            for (HistoricTaskInstance historicSubTask : historicSubTasks) {
                subTaskNames.add(historicSubTask.getName());
            }
            Assert.assertEquals(expectedSubTaskNames, subTaskNames);
        }
        this.taskService.deleteTask(gonzoTaskId, true);
    }
}

