/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.async;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AsyncTaskTest
extends PluggableProcessEngineTest {
    public static boolean INVOCATION;
    public static int NUM_INVOCATIONS;

    @Deployment
    @Test
    public void testAsyncServiceNoListeners() {
        INVOCATION = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)activityInstance.getChildTransitionInstances().length);
        Assert.assertEquals((long)0L, (long)activityInstance.getChildActivityInstances().length);
        Assert.assertNotNull((Object)activityInstance.getChildTransitionInstances()[0]);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertFalse((boolean)INVOCATION);
        this.testRule.executeAvailableJobs();
        Assert.assertTrue((boolean)INVOCATION);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncServiceListeners() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncService").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncServiceConcurrent() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertFalse((boolean)INVOCATION);
        this.testRule.executeAvailableJobs();
        Assert.assertTrue((boolean)INVOCATION);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncSequentialMultiInstanceWithServiceTask() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        this.testRule.executeAvailableJobs(1);
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncParallelMultiInstanceWithServiceTask() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        this.testRule.executeAvailableJobs(1);
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncServiceWrappedInSequentialMultiInstance() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs(5);
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncServiceWrappedInParallelMultiInstance() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)5L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs(5);
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncBeforeAndAfterOfServiceWrappedInParallelMultiInstance() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)5L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs(10);
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncBeforeSequentialMultiInstanceWithAsyncAfterServiceWrappedInMultiInstance() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs(6);
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    protected void assertTransitionInstances(String processInstanceId, String activityId, int numInstances) {
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertEquals((long)numInstances, (long)tree.getTransitionInstances(activityId).length);
    }

    @Deployment
    @Test
    public void testAsyncBeforeAndAfterParallelMultiInstanceWithAsyncBeforeAndAfterServiceWrappedInMultiInstance() {
        NUM_INVOCATIONS = 0;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.assertTransitionInstances(processInstance.getId(), "service#multiInstanceBody", 1);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        List innerBeforeJobs = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)5L, (long)innerBeforeJobs.size());
        this.assertTransitionInstances(processInstance.getId(), "service", 5);
        Assert.assertEquals((long)0L, (long)NUM_INVOCATIONS);
        for (Job innerBeforeJob : innerBeforeJobs) {
            this.managementService.executeJob(innerBeforeJob.getId());
        }
        Assert.assertEquals((long)5L, (long)NUM_INVOCATIONS);
        List innerAfterJobs = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)5L, (long)innerAfterJobs.size());
        this.assertTransitionInstances(processInstance.getId(), "service", 5);
        for (Job innerAfterJob : innerAfterJobs) {
            this.managementService.executeJob(innerAfterJob.getId());
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.assertTransitionInstances(processInstance.getId(), "service#multiInstanceBody", 1);
        this.managementService.executeJob(job.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsyncServiceWrappedInParallelMultiInstance.bpmn20.xml"})
    @Test
    public void testAsyncServiceWrappedInParallelMultiInstanceActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)5L, (long)this.managementService.createJobQuery().count());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("service#multiInstanceBody").transition("service").transition("service").transition("service").transition("service").transition("service").done());
    }

    @Deployment
    @Test
    public void testFailingAsyncServiceTimer() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        if (!(job instanceof MessageEntity)) {
            Assert.fail((String)"the job must be a message");
        }
        this.testRule.executeAvailableJobs();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)"service", this.runtimeService.getActiveActivityIds(execution.getId()).get(0));
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(execution.getId(), "dead");
    }

    @Deployment
    @Ignore
    @Test
    public void testFailingAsyncServiceTimerWithMessageJob() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)"service", this.runtimeService.getActiveActivityIds(execution.getId()).get(0));
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.testRule.executeAvailableJobs();
        Assert.assertNull((Object)this.runtimeService.createExecutionQuery().singleResult());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncServiceSubProcessTimer() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        Assert.assertFalse((boolean)INVOCATION);
        Job job = (Job)this.managementService.createJobQuery().messages().singleResult();
        this.managementService.executeJob(job.getId());
        Assert.assertTrue((boolean)INVOCATION);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncServiceSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("subProcess").done());
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncTask() {
        this.runtimeService.startProcessInstanceByKey("asyncTask");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncScript() {
        this.runtimeService.startProcessInstanceByKey("asyncScript").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        String eid = ((Execution)this.runtimeService.createExecutionQuery().singleResult()).getId();
        Assert.assertNull((Object)this.runtimeService.getVariable(eid, "invoked"));
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertEquals((Object)"true", (Object)this.runtimeService.getVariable(eid, "invoked"));
        this.runtimeService.signal(eid);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsyncCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsyncServiceNoListeners.bpmn20.xml"})
    @Test
    public void testAsyncCallActivity() {
        this.runtimeService.startProcessInstanceByKey("asyncCallactivity");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testAsyncUserTask() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncUserTask").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    @Test
    public void testAsyncManualTask() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncManualTask").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    @Test
    public void testAsyncIntermediateCatchEvent() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncIntermediateCatchEvent").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        this.runtimeService.correlateMessage("testMessage1");
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    @Test
    public void testAsyncIntermediateThrowEvent() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncIntermediateThrowEvent").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    @Test
    public void testAsyncExclusiveGateway() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("flow", false);
        String pid = this.runtimeService.startProcessInstanceByKey("asyncExclusiveGateway", variables).getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    @Test
    public void testAsyncInclusiveGateway() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncInclusiveGateway").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        List list = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Task task : list) {
            this.taskService.complete(task.getId());
        }
    }

    @Deployment
    @Test
    public void testAsyncEventGateway() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncEventGateway").getProcessInstanceId();
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.correlateMessage("testMessageDef1");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    @Test
    public void testDeleteShouldNotInvokeListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncListener", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        Assert.assertEquals((long)0L, (long)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.clear();
    }

    @Deployment
    @Test
    public void testDeleteInScopeShouldNotInvokeListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncListenerSubProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"subProcess", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertNull((Object)recordedEvents.get(1).getActivityId());
        RecorderExecutionListener.clear();
    }

    @Deployment
    @Test
    public void testDeleteShouldNotInvokeOutputMapping() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncOutputMapping");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_AUDIT.getId()) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        }
    }

    @Deployment
    @Test
    public void testDeleteInScopeShouldNotInvokeOutputMapping() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncOutputMappingSubProcess");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_AUDIT.getId()) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("taskOutputMappingExecuted").count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("subProcessOutputMappingExecuted").count());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployAndRemoveAsyncActivity() {
        HashSet<String> deployments = new HashSet<String>();
        try {
            org.eximeebpms.bpm.engine.repository.Deployment deployment1 = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/async/AsyncTaskTest.testDeployAndRemoveAsyncActivity.v1.bpmn20.xml").deploy();
            deployments.add(deployment1.getId());
            org.eximeebpms.bpm.engine.repository.Deployment deployment2 = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/async/AsyncTaskTest.testDeployAndRemoveAsyncActivity.v2.bpmn20.xml").deploy();
            deployments.add(deployment2.getId());
            this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
            Assert.assertNotNull((Object)processInstance);
        }
        finally {
            for (String deploymentId : deployments) {
                this.repositoryService.deleteDeployment(deploymentId, true);
            }
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/processWithGatewayAndTwoEndEvents.bpmn20.xml"})
    @Test
    public void testGatewayWithTwoEndEventsLastJobReAssignedToParentExe() {
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processKey).getId();
        List jobList = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)2L, (long)jobList.size());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)1L, (long)jobList.size());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().list().size());
        Assert.assertEquals((Object)processInstanceId, (Object)((Job)jobList.get(0)).getExecutionId());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)0L, (long)jobList.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/processGatewayAndTwoEndEventsPlusTimer.bpmn20.xml"})
    @Test
    public void testGatewayWithTwoEndEventsLastTimerReAssignedToParentExe() {
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processKey).getId();
        List jobList = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)2L, (long)jobList.size());
        String timerId = ((Job)this.managementService.createJobQuery().timers().singleResult()).getId();
        this.managementService.executeJob(timerId);
        jobList = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)1L, (long)jobList.size());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().list().size());
        Assert.assertEquals((Object)processInstanceId, (Object)((Job)jobList.get(0)).getExecutionId());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)0L, (long)jobList.size());
    }

    @Deployment
    @Ignore
    @Test
    public void testLongProcessDefinitionKey() {
        String key = "myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((Object)key, (Object)job.getProcessDefinitionKey());
    }

    static {
        NUM_INVOCATIONS = 0;
    }
}

