/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.link;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class LinkEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testValidEventLink() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("linkEventValid");
        List activeActivities = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertEquals(Arrays.asList("waitAfterLink1"), (Object)activeActivities);
        this.runtimeService.signal(pi.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertEquals(Arrays.asList("waitAfterLink2"), (Object)activeActivities);
        this.runtimeService.signal(pi.getId());
        this.testRule.assertProcessEnded(pi.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi.getId()).orderByActivityId().asc()).list();
            Assert.assertEquals((long)4L, (long)activities.size());
            Assert.assertEquals((Object)"EndEvent_1", (Object)((HistoricActivityInstance)activities.get(0)).getActivityId());
            Assert.assertEquals((Object)"StartEvent_1", (Object)((HistoricActivityInstance)activities.get(1)).getActivityId());
            Assert.assertEquals((Object)"waitAfterLink1", (Object)((HistoricActivityInstance)activities.get(2)).getActivityId());
            Assert.assertEquals((Object)"waitAfterLink2", (Object)((HistoricActivityInstance)activities.get(3)).getActivityId());
        }
    }

    @Deployment
    @Test
    public void testEventLinkMultipleSources() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("linkEventValid");
        List activeActivities = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertEquals(Arrays.asList("WaitAfterLink", "WaitAfterLink"), (Object)activeActivities);
        this.runtimeService.deleteProcessInstance(pi.getId(), "test done");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi.getId()).orderByActivityId().asc()).list();
            Assert.assertEquals((long)5L, (long)activities.size());
            Assert.assertEquals((Object)"ManualTask_1", (Object)((HistoricActivityInstance)activities.get(0)).getActivityId());
            Assert.assertEquals((Object)"ParallelGateway_1", (Object)((HistoricActivityInstance)activities.get(1)).getActivityId());
            Assert.assertEquals((Object)"StartEvent_1", (Object)((HistoricActivityInstance)activities.get(2)).getActivityId());
            Assert.assertEquals((Object)"WaitAfterLink", (Object)((HistoricActivityInstance)activities.get(3)).getActivityId());
            Assert.assertEquals((Object)"WaitAfterLink", (Object)((HistoricActivityInstance)activities.get(4)).getActivityId());
        }
    }

    @Test
    public void testInvalidEventLinkMultipleTargets() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/event/link/LinkEventTest.testInvalidEventLinkMultipleTargets.bpmn20.xml").deploy();
            Assert.fail((String)"process should not deploy because it contains multiple event link targets which is invalid in the BPMN 2.0 spec");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Multiple Intermediate Catch Events with the same link event name ('LinkA') are not allowed"));
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"IntermediateCatchEvent_2");
        }
    }

    @Test
    public void testCatchLinkEventAfterEventBasedGatewayNotAllowed() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/event/link/LinkEventTest.testCatchLinkEventAfterEventBasedGatewayNotAllowed.bpmn20.xml").deploy();
            Assert.fail((String)"process should not deploy because it contains multiple event link targets which is invalid in the BPMN 2.0 spec");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IntermediateCatchLinkEvent is not allowed after an EventBasedGateway."));
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"IntermediateCatchEvent_2");
        }
    }
}

