/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.message;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class MessageBoundaryEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSingleBoundaryMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterTask", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Test
    public void testDoubleBoundaryMessageEventSameMessageId() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/event/message/MessageBoundaryEventTest.testDoubleBoundaryMessageEventSameMessageId.bpmn20.xml").deploy();
            Assert.fail((String)"Deployment should fail because Activiti cannot handle two boundary message events with same messageId.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot have more than one message event subscription with name 'messageName' for scope 'task'", e.getMessage());
            Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"messageBoundary_2");
        }
    }

    @Deployment
    @Test
    public void testDoubleBoundaryMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        Assert.assertNotNull((Object)execution1);
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        Assert.assertNotNull((Object)execution2);
        Assert.assertEquals((Object)execution1.getId(), (Object)execution2.getId());
        this.runtimeService.messageEventReceived("messageName_1", execution1.getId());
        try {
            this.runtimeService.messageEventReceived("messageName_2", execution2.getId());
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("does not have a subscription to a message event with name 'messageName_2'", e.getMessage());
        }
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage_1", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        Assert.assertNull((Object)execution1);
        execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        Assert.assertNull((Object)execution2);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterTask", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testDoubleBoundaryMessageEventMultiInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)7L, (long)this.runtimeService.createExecutionQuery().count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        Assert.assertEquals((Object)execution1.getId(), (Object)execution2.getId());
        this.runtimeService.messageEventReceived("messageName_1", execution1.getId());
        try {
            this.runtimeService.messageEventReceived("messageName_2", execution2.getId());
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("does not have a subscription to a message event with name 'messageName_2'", e.getMessage());
        }
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage_1", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)7L, (long)this.runtimeService.createExecutionQuery().count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        Assert.assertEquals((Object)execution1.getId(), (Object)execution2.getId());
        List userTasks = this.taskService.createTaskQuery().list();
        Assert.assertNotNull((Object)userTasks);
        Assert.assertEquals((long)5L, (long)userTasks.size());
        for (int i = 0; i < userTasks.size() - 1; ++i) {
            Task task = (Task)userTasks.get(i);
            this.taskService.complete(task.getId());
            execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
            Assert.assertNotNull((Object)execution1);
            execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
            Assert.assertNotNull((Object)execution2);
        }
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        Assert.assertNull((Object)execution1);
        execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        Assert.assertNull((Object)execution2);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterTask", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testBoundaryMessageEventInsideSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterTask", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testBoundaryMessageEventOnSubprocessAndInsideSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNotNull((Object)execution1);
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        Assert.assertNotNull((Object)execution2);
        Assert.assertNotSame((Object)execution1.getId(), (Object)execution2.getId());
        this.taskService.complete(userTask.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterTask", (Object)userTask.getTaskDefinitionKey());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        Assert.assertNotNull((Object)execution);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        Assert.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterSubprocess", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.runtimeService.startProcessInstanceByKey("process");
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage", (Object)userTask.getTaskDefinitionKey());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        Assert.assertNotNull((Object)execution);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        Assert.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterSubprocess", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.runtimeService.startProcessInstanceByKey("process");
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        this.runtimeService.messageEventReceived("messageName2", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterOuterMessageBoundary", (Object)userTask.getTaskDefinitionKey());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        Assert.assertNull((Object)execution);
        this.taskService.complete(userTask.getId());
    }

    @Deployment
    @Test
    public void testBoundaryMessageEventOnSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Execution executionMessageOne = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_one").singleResult();
        Assert.assertNotNull((Object)executionMessageOne);
        this.runtimeService.messageEventReceived("messageName_one", executionMessageOne.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage_one", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        Execution executionMessageTwo = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_two").singleResult();
        Assert.assertNotNull((Object)executionMessageTwo);
        this.runtimeService.messageEventReceived("messageName_two", executionMessageTwo.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage_two", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        executionMessageOne = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_one").singleResult();
        Assert.assertNull((Object)executionMessageOne);
        executionMessageTwo = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_two").singleResult();
        Assert.assertNull((Object)executionMessageTwo);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterSubProcess", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testBoundaryMessageEventOnSubprocessWithIntermediateMessageCatch() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("cancelMessage");
        this.testRule.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List hais = this.historyService.createHistoricActivityInstanceQuery().list();
            for (HistoricActivityInstance historicActivityInstance : hais) {
                Assert.assertNotNull((Object)historicActivityInstance.getEndTime());
            }
        }
    }

    @Deployment
    @Test
    public void testBoundaryMessageEventOnSubprocessAndInsideSubprocessMultiInstance() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)17L, (long)this.runtimeService.createExecutionQuery().count());
        List userTasks = this.taskService.createTaskQuery().list();
        Assert.assertNotNull((Object)userTasks);
        Assert.assertEquals((long)5L, (long)userTasks.size());
        List executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)5L, (long)executions.size());
        executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)1L, (long)executions.size());
        Execution outerScopeExecution = (Execution)executions.get(0);
        this.runtimeService.messageEventReceived("messageName2", outerScopeExecution.getId());
        executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").list();
        Assert.assertEquals((long)0L, (long)executions.size());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterOuterMessageBoundary", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment
    @Test
    public void testBoundaryMessageEventConcurrent() {
        this.runtimeService.startProcessInstanceByKey("boundaryEvent");
        EventSubscription eventSubscriptionTask1 = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().activityId("messageBoundary1").singleResult();
        Assert.assertNotNull((Object)eventSubscriptionTask1);
        EventSubscription eventSubscriptionTask2 = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().activityId("messageBoundary2").singleResult();
        Assert.assertNotNull((Object)eventSubscriptionTask2);
        this.runtimeService.correlateMessage("task1Message");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertNotNull((Object)this.runtimeService.createEventSubscriptionQuery().activityId("messageBoundary2").singleResult());
    }

    @Deployment
    @Test
    public void testExpressionInBoundaryMessageEventName() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName-bar").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName-bar", execution.getId());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }
}

