/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.servicetask;

import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;
import org.eximeebpms.bpm.engine.test.bpmn.common.AbstractProcessEngineServicesAccessTest;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.instance.ServiceTask;
import org.eximeebpms.bpm.model.bpmn.instance.Task;

public class JavaDelegateProcessEngineServicesAccessTest
extends AbstractProcessEngineServicesAccessTest {
    @Override
    protected Class<?> getTestServiceAccessibleClass() {
        return AccessServicesJavaDelegate.class;
    }

    @Override
    protected Class<?> getQueryClass() {
        return PerformQueryJavaDelegate.class;
    }

    @Override
    protected Class<?> getStartProcessInstanceClass() {
        return StartProcessJavaDelegate.class;
    }

    @Override
    protected Class<?> getProcessEngineStartProcessClass() {
        return ProcessEngineStartProcessJavaDelegate.class;
    }

    @Override
    protected Task createModelAccessTask(BpmnModelInstance modelInstance, Class<?> delegateClass) {
        ServiceTask serviceTask = (ServiceTask)modelInstance.newInstance(ServiceTask.class);
        serviceTask.setId("serviceTask");
        serviceTask.setCamundaClass(delegateClass.getName());
        return serviceTask;
    }

    public static class AccessServicesJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanAccessServices(execution.getProcessEngineServices());
        }
    }

    public static class PerformQueryJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanPerformQuery(execution.getProcessEngineServices());
        }
    }

    public static class StartProcessJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngineServices());
        }
    }

    public static class ProcessEngineStartProcessJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngine());
        }
    }
}

