/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.handler;

import java.util.List;
import org.eximeebpms.bpm.engine.delegate.Expression;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.eximeebpms.bpm.engine.impl.cmmn.handler.CaseTaskItemHandler;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.eximeebpms.bpm.engine.impl.variable.listener.ClassDelegateCaseVariableListener;
import org.eximeebpms.bpm.engine.impl.variable.listener.DelegateExpressionCaseVariableListener;
import org.eximeebpms.bpm.engine.impl.variable.listener.ExpressionCaseVariableListener;
import org.eximeebpms.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.eximeebpms.bpm.engine.test.cmmn.handler.specification.SpecUtil;
import org.eximeebpms.bpm.model.cmmn.instance.CaseTask;
import org.eximeebpms.bpm.model.cmmn.instance.CmmnElement;
import org.eximeebpms.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.eximeebpms.bpm.model.cmmn.instance.ExtensionElements;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItem;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItemDefinition;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaField;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaVariableListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaseVariableListenerHandlerTest
extends CmmnElementHandlerTest {
    protected CaseTask caseTask;
    protected PlanItem planItem;
    protected CaseTaskItemHandler handler = new CaseTaskItemHandler();

    @Before
    public void setUp() {
        this.caseTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aCaseTask", CaseTask.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aCaseTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.caseTask);
    }

    @Test
    public void testClassDelegateHandling() {
        ExtensionElements extensionElements = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)this.caseTask, null, ExtensionElements.class);
        CamundaVariableListener variableListener = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)extensionElements, null, CamundaVariableListener.class);
        CamundaField field = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)variableListener, null, CamundaField.class);
        field.setCamundaName("fieldName");
        field.setCamundaStringValue("a string value");
        variableListener.setCamundaClass("a.class.Name");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List listeners = activity.getVariableListenersLocal("create");
        Assert.assertEquals((long)1L, (long)listeners.size());
        ClassDelegateCaseVariableListener listener = (ClassDelegateCaseVariableListener)listeners.get(0);
        Assert.assertEquals((Object)"a.class.Name", (Object)listener.getClassName());
        Assert.assertEquals((long)1L, (long)listener.getFieldDeclarations().size());
        Assert.assertEquals((Object)"fieldName", (Object)((FieldDeclaration)listener.getFieldDeclarations().get(0)).getName());
        Object fieldValue = ((FieldDeclaration)listener.getFieldDeclarations().get(0)).getValue();
        Assert.assertTrue((boolean)(fieldValue instanceof Expression));
        Expression expressionValue = (Expression)fieldValue;
        Assert.assertEquals((Object)"a string value", (Object)expressionValue.getExpressionText());
        Assert.assertEquals((Object)listener, activity.getVariableListenersLocal("update").get(0));
        Assert.assertEquals((Object)listener, activity.getVariableListenersLocal("delete").get(0));
    }

    @Test
    public void testDelegateExpressionDelegateHandling() {
        ExtensionElements extensionElements = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)this.caseTask, null, ExtensionElements.class);
        CamundaVariableListener variableListener = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)extensionElements, null, CamundaVariableListener.class);
        variableListener.setCamundaDelegateExpression("${expression}");
        variableListener.setCamundaEvent("create");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List listeners = activity.getVariableListenersLocal("create");
        Assert.assertEquals((long)1L, (long)listeners.size());
        DelegateExpressionCaseVariableListener listener = (DelegateExpressionCaseVariableListener)listeners.get(0);
        Assert.assertEquals((Object)"${expression}", (Object)listener.getExpressionText());
        Assert.assertEquals((long)0L, (long)activity.getVariableListenersLocal("update").size());
        Assert.assertEquals((long)0L, (long)activity.getVariableListenersLocal("delete").size());
    }

    @Test
    public void testExpressionDelegateHandling() {
        ExtensionElements extensionElements = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)this.caseTask, null, ExtensionElements.class);
        CamundaVariableListener variableListener = SpecUtil.createElement(this.modelInstance, (CmmnModelElementInstance)extensionElements, null, CamundaVariableListener.class);
        variableListener.setCamundaExpression("${expression}");
        variableListener.setCamundaEvent("create");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List listeners = activity.getVariableListenersLocal("create");
        Assert.assertEquals((long)1L, (long)listeners.size());
        ExpressionCaseVariableListener listener = (ExpressionCaseVariableListener)listeners.get(0);
        Assert.assertEquals((Object)"${expression}", (Object)listener.getExpressionText());
        Assert.assertEquals((long)0L, (long)activity.getVariableListenersLocal("update").size());
        Assert.assertEquals((long)0L, (long)activity.getVariableListenersLocal("delete").size());
    }
}

