/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.handler;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.bpmn.helper.CmmnProperties;
import org.eximeebpms.bpm.engine.impl.cmmn.CaseControlRule;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.ProcessTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.eximeebpms.bpm.engine.impl.cmmn.handler.ProcessTaskItemHandler;
import org.eximeebpms.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.eximeebpms.bpm.engine.impl.core.model.BaseCallableElement;
import org.eximeebpms.bpm.engine.impl.core.model.CallableElement;
import org.eximeebpms.bpm.engine.impl.core.model.CallableElementParameter;
import org.eximeebpms.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import org.eximeebpms.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.eximeebpms.bpm.engine.impl.el.ElValueProvider;
import org.eximeebpms.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.eximeebpms.bpm.model.cmmn.Cmmn;
import org.eximeebpms.bpm.model.cmmn.CmmnModelInstance;
import org.eximeebpms.bpm.model.cmmn.instance.Body;
import org.eximeebpms.bpm.model.cmmn.instance.CmmnElement;
import org.eximeebpms.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.eximeebpms.bpm.model.cmmn.instance.ConditionExpression;
import org.eximeebpms.bpm.model.cmmn.instance.DefaultControl;
import org.eximeebpms.bpm.model.cmmn.instance.EntryCriterion;
import org.eximeebpms.bpm.model.cmmn.instance.ExitCriterion;
import org.eximeebpms.bpm.model.cmmn.instance.ExtensionElements;
import org.eximeebpms.bpm.model.cmmn.instance.IfPart;
import org.eximeebpms.bpm.model.cmmn.instance.ItemControl;
import org.eximeebpms.bpm.model.cmmn.instance.ManualActivationRule;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItem;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItemControl;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItemDefinition;
import org.eximeebpms.bpm.model.cmmn.instance.ProcessTask;
import org.eximeebpms.bpm.model.cmmn.instance.RepetitionRule;
import org.eximeebpms.bpm.model.cmmn.instance.RequiredRule;
import org.eximeebpms.bpm.model.cmmn.instance.Sentry;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaIn;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaOut;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessTaskPlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected ProcessTask processTask;
    protected PlanItem planItem;
    protected ProcessTaskItemHandler handler = new ProcessTaskItemHandler();

    @Before
    public void setUp() {
        this.processTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aProcessTask", ProcessTask.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aProcessTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.processTask);
    }

    @Test
    public void testProcessTaskActivityName() {
        String name = "A ProcessTask";
        this.processTask.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String processTaskName = "A ProcessTask";
        this.processTask.setName(processTaskName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNotEquals((Object)processTaskName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testProcessTaskActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"processTask", (Object)activityType);
    }

    @Test
    public void testProcessTaskDescription() {
        String description = "This is a processTask";
        this.processTask.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testPlanItemDescription() {
        String description = "This is a planItem";
        this.planItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof ProcessTaskActivityBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.processTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertFalse((boolean)isBlocking);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testCallableElement() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getCallableElement());
    }

    @Test
    public void testProcessRefConstant() {
        String processRef = "aProcessToCall";
        this.processTask.setProcess(processRef);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider processRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)processRefValueProvider);
        Assert.assertTrue((boolean)(processRefValueProvider instanceof ConstantValueProvider));
        ConstantValueProvider valueProvider = (ConstantValueProvider)processRefValueProvider;
        Assert.assertEquals((Object)processRef, (Object)valueProvider.getValue(null));
    }

    @Test
    public void testProcessRefExpression() {
        String processRef = "${aProcessToCall}";
        this.processTask.setProcess(processRef);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider processRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)processRefValueProvider);
        Assert.assertTrue((boolean)(processRefValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)processRefValueProvider;
        Assert.assertEquals((Object)processRef, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testBinding() {
        BaseCallableElement.CallableElementBinding processBinding = BaseCallableElement.CallableElementBinding.LATEST;
        this.processTask.setCamundaProcessBinding(processBinding.getValue());
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        BaseCallableElement.CallableElementBinding binding = callableElement.getBinding();
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)processBinding, (Object)binding);
    }

    @Test
    public void testVersionConstant() {
        String processVersion = "2";
        this.processTask.setCamundaProcessVersion(processVersion);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider processVersionValueProvider = callableElement.getVersionValueProvider();
        Assert.assertNotNull((Object)processVersionValueProvider);
        Assert.assertTrue((boolean)(processVersionValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)processVersion, (Object)processVersionValueProvider.getValue(null));
    }

    @Test
    public void testVersionExpression() {
        String processVersion = "${aVersion}";
        this.processTask.setCamundaProcessVersion(processVersion);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider processVersionValueProvider = callableElement.getVersionValueProvider();
        Assert.assertNotNull((Object)processVersionValueProvider);
        Assert.assertTrue((boolean)(processVersionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)processVersionValueProvider;
        Assert.assertEquals((Object)processVersion, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testBusinessKeyConstant() {
        String businessKey = "myBusinessKey";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn businessKeyElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        businessKeyElement.setCamundaBusinessKey(businessKey);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider businessKeyValueProvider = callableElement.getBusinessKeyValueProvider();
        Assert.assertNotNull((Object)businessKeyValueProvider);
        Assert.assertTrue((boolean)(businessKeyValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)businessKey, (Object)businessKeyValueProvider.getValue(null));
    }

    @Test
    public void testBusinessKeyExpression() {
        String businessKey = "${myBusinessKey}";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn businessKeyElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        businessKeyElement.setCamundaBusinessKey(businessKey);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider businessKeyValueProvider = callableElement.getBusinessKeyValueProvider();
        Assert.assertNotNull((Object)businessKeyValueProvider);
        Assert.assertTrue((boolean)(businessKeyValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)businessKeyValueProvider;
        Assert.assertEquals((Object)businessKey, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testInputs() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        variablesElement.setCamundaVariables("all");
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaSource("a");
        CamundaIn sourceExpressionElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceExpressionElement.setCamundaSourceExpression("${b}");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        List inputs = callableElement.getInputs();
        Assert.assertNotNull((Object)inputs);
        Assert.assertFalse((boolean)inputs.isEmpty());
        Assert.assertEquals((long)3L, (long)inputs.size());
    }

    @Test
    public void testInputVariables() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        variablesElement.setCamundaVariables("all");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isAllVariables());
    }

    @Test
    public void testInputSource() {
        String source = "a";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaSource(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceValueProvider);
        Assert.assertTrue((boolean)(sourceValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)source, (Object)sourceValueProvider.getValue(null));
    }

    @Test
    public void testInputSourceExpression() {
        String source = "${a}";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaSourceExpression(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceExpressionValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceExpressionValueProvider);
        Assert.assertTrue((boolean)(sourceExpressionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)sourceExpressionValueProvider;
        Assert.assertEquals((Object)source, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testInputTarget() {
        String target = "b";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaTarget(target);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        Assert.assertEquals((Object)target, (Object)parameter.getTarget());
    }

    @Test
    public void testOutputs() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaOut variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        variablesElement.setCamundaVariables("all");
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaSource("a");
        CamundaOut sourceExpressionElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceExpressionElement.setCamundaSourceExpression("${b}");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        List outputs = callableElement.getOutputs();
        Assert.assertNotNull((Object)outputs);
        Assert.assertFalse((boolean)outputs.isEmpty());
        Assert.assertEquals((long)3L, (long)outputs.size());
    }

    @Test
    public void testOutputVariables() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaOut variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        variablesElement.setCamundaVariables("all");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isAllVariables());
    }

    @Test
    public void testOutputSource() {
        String source = "a";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaSource(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceValueProvider);
        Assert.assertTrue((boolean)(sourceValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)source, (Object)sourceValueProvider.getValue(null));
    }

    @Test
    public void testOutputSourceExpression() {
        String source = "${a}";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaSourceExpression(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceExpressionValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceExpressionValueProvider);
        Assert.assertTrue((boolean)(sourceExpressionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)sourceExpressionValueProvider;
        Assert.assertEquals((Object)source, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testOutputTarget() {
        String target = "b";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.processTask);
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaTarget(target);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        ProcessTaskActivityBehavior behavior = (ProcessTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        Assert.assertEquals((Object)target, (Object)parameter.getTarget());
    }

    @Test
    public void testExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        ExitCriterion criterion = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
    }

    @Test
    public void testMultipleExitCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        conditionExpression1.setText("${test}");
        ExitCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion1.setSentry(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        conditionExpression2.setText("${test}");
        ExitCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion2.setSentry(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getExitCriteria().size());
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        conditionExpression.setText("${test}");
        EntryCriterion criterion = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testMultipleEntryCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        conditionExpression1.setText("${test}");
        EntryCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion1.setSentry(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        conditionExpression2.setText("${test}");
        EntryCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion2.setSentry(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getEntryCriteria().size());
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteriaAndExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        conditionExpression.setText("${test}");
        EntryCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion1.setSentry(sentry);
        ExitCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion2.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testManualActivationRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)itemControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testManualActivationRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.processTask, "ItemControl_1", DefaultControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)defaultControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.processTask, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRepetitionRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)itemControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("repetitionRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRepetitionRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.processTask, "DefaultControl_1", DefaultControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)defaultControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("repetitionRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRepetitionRuleStandardEvents() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)itemControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("complete"));
        Assert.assertTrue((boolean)events.contains("terminate"));
    }

    @Test
    public void testRepetitionRuleStandardEventsByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.processTask, "DefaultControl_1", DefaultControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)defaultControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("complete"));
        Assert.assertTrue((boolean)events.contains("terminate"));
    }

    @Test
    public void testRepetitionRuleCustomStandardEvents() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)itemControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        repetitionRule.setCamundaRepeatOnStandardEvent("disable");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("disable"));
    }

    @Test
    public void testRepetitionRuleCustomStandardEventsByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.processTask, "DefaultControl_1", DefaultControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)defaultControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        repetitionRule.setCamundaRepeatOnStandardEvent("disable");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("disable"));
    }
}

