/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.util.Map;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.junit.Assert;
import org.junit.Test;

public class CompetingByteVariableAccessTest
extends ConcurrencyTestCase {
    private ConcurrencyTestHelper.ThreadControl asyncThread;

    @Test
    public void testConcurrentVariableRemoval() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"test").startEvent().userTask().endEvent().done());
        byte[] byteVar = "asd".getBytes();
        String pid = this.runtimeService.startProcessInstanceByKey("test", (Map)Variables.createVariables().putValue("byteVar", (Object)byteVar)).getId();
        this.asyncThread = this.executeControllableCommand(new FetchAndUpdateVariableCmd(pid, "byteVar", "bsd".getBytes()));
        this.asyncThread.waitForSync();
        this.runtimeService.deleteProcessInstance(pid, null);
        this.asyncThread.reportInterrupts();
        this.asyncThread.waitUntilDone();
        Throwable exception = this.asyncThread.getException();
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    static class FetchAndUpdateVariableCmd
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String executionId;
        protected String varName;
        protected Object newValue;

        public FetchAndUpdateVariableCmd(String executionId, String varName, Object newValue) {
            this.executionId = executionId;
            this.varName = varName;
            this.newValue = newValue;
        }

        public Void execute(CommandContext commandContext) {
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
            VariableInstanceEntity varInstance = (VariableInstanceEntity)execution.getVariableInstanceLocal(this.varName);
            String byteArrayValueId = varInstance.getByteArrayValueId();
            Assert.assertNotNull((String)"Byte array id is expected to be not null", (Object)byteArrayValueId);
            CachedDbEntity cachedByteArray = commandContext.getDbEntityManager().getDbEntityCache().getCachedEntity(ByteArrayEntity.class, byteArrayValueId);
            Assert.assertNull((String)"Byte array is expected to be not fetched yet / lazily fetched.", (Object)cachedByteArray);
            this.monitor.sync();
            execution.setVariableLocal(varInstance.getName(), this.newValue);
            return null;
        }
    }
}

