/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.List;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEvent;
import org.eximeebpms.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

@RequiredHistoryLevel(value="full")
public abstract class AbstractCompositeHistoryEventHandlerTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected HistoryEventHandler originalHistoryEventHandler;
    protected int countCustomHistoryEventHandler;

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.originalHistoryEventHandler = this.processEngineConfiguration.getHistoryEventHandler();
        this.countCustomHistoryEventHandler = 0;
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setHistoryEventHandler(this.originalHistoryEventHandler);
    }

    protected void startProcessAndCompleteUserTask() {
        this.runtimeService.startProcessInstanceByKey("HistoryLevelTest");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    protected class CustomDbHistoryEventHandler
    implements HistoryEventHandler {
        protected CustomDbHistoryEventHandler() {
        }

        public void handleEvent(HistoryEvent historyEvent) {
            if (historyEvent instanceof HistoricVariableUpdateEventEntity) {
                ++AbstractCompositeHistoryEventHandlerTest.this.countCustomHistoryEventHandler;
            }
        }

        public void handleEvents(List<HistoryEvent> historyEvents) {
            for (HistoryEvent historyEvent : historyEvents) {
                this.handleEvent(historyEvent);
            }
        }
    }
}

