/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.useroperationlog;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.task.DelegationState;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogTaskServiceAndBeanTest
extends AbstractUserOperationLogTest {
    protected Task task;

    @After
    public void tearDown() throws Exception {
        if (this.task != null) {
            this.taskService.deleteTask(this.task.getId(), true);
        }
    }

    @Test
    public void testBeanPropertyChanges() {
        TaskEntity entity = new TaskEntity();
        entity.setAssignee("icke");
        Map changes = entity.getPropertyChanges();
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertNull((Object)((PropertyChange)changes.get("assignee")).getOrgValue());
        Assert.assertEquals((Object)"icke", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        entity.setAssignee("er");
        changes = entity.getPropertyChanges();
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertNull((Object)((PropertyChange)changes.get("assignee")).getOrgValue());
        Assert.assertEquals((Object)"er", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        entity.setDueDate(new Date());
        changes = entity.getPropertyChanges();
        Assert.assertEquals((long)2L, (long)changes.size());
    }

    @Test
    public void testNotTrackChangeToTheSameValue() {
        TaskEntity entity = new TaskEntity();
        entity.setPriority(entity.getPriority());
        entity.setOwner(entity.getOwner());
        entity.setFollowUpDate(entity.getFollowUpDate());
        Assert.assertTrue((boolean)entity.getPropertyChanges().isEmpty());
    }

    @Test
    public void testRemoveChangeWhenSetBackToTheOrgValue() {
        TaskEntity entity = new TaskEntity();
        entity.setOwner("icke");
        Assert.assertFalse((boolean)entity.getPropertyChanges().isEmpty());
        entity.setOwner(null);
        Assert.assertTrue((boolean)entity.getPropertyChanges().isEmpty());
    }

    @Test
    public void testAllTrackedProperties() {
        Date yesterday = new Date(new Date().getTime() - 86400000L);
        Date tomorrow = new Date(new Date().getTime() + 86400000L);
        TaskEntity entity = new TaskEntity();
        entity.setAssignee("er");
        entity.setDelegationState(DelegationState.PENDING);
        entity.setDeleted(true);
        entity.setDescription("a description");
        entity.setDueDate(tomorrow);
        entity.setFollowUpDate(yesterday);
        entity.setName("to do");
        entity.setOwner("icke");
        entity.setParentTaskId("parent");
        entity.setPriority(73);
        Map changes = entity.getPropertyChanges();
        Assert.assertEquals((Object)"er", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        Assert.assertSame((Object)DelegationState.PENDING, (Object)((PropertyChange)changes.get("delegation")).getNewValue());
        Assert.assertEquals((Object)"a description", (Object)((PropertyChange)changes.get("description")).getNewValue());
        Assert.assertEquals((Object)tomorrow, (Object)((PropertyChange)changes.get("dueDate")).getNewValue());
        Assert.assertEquals((Object)yesterday, (Object)((PropertyChange)changes.get("followUpDate")).getNewValue());
        Assert.assertEquals((Object)"to do", (Object)((PropertyChange)changes.get("name")).getNewValue());
        Assert.assertEquals((Object)"icke", (Object)((PropertyChange)changes.get("owner")).getNewValue());
        Assert.assertEquals((Object)"parent", (Object)((PropertyChange)changes.get("parentTask")).getNewValue());
        Assert.assertEquals((Object)73, (Object)((PropertyChange)changes.get("priority")).getNewValue());
    }

    @Test
    public void testDeleteTask() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.taskService.deleteTask(this.task.getId(), "duplicated");
        UserOperationLogQuery query = this.queryOperationDetails("Delete");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry delete = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"delete", (Object)delete.getProperty());
        Assert.assertFalse((boolean)Boolean.parseBoolean(delete.getOrgValue()));
        Assert.assertTrue((boolean)Boolean.parseBoolean(delete.getNewValue()));
        Assert.assertEquals((Object)"TaskWorker", (Object)delete.getCategory());
    }

    @Test
    public void testCompositeBeanInteraction() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        UserOperationLogQuery query = this.queryOperationDetails("Create");
        UserOperationLogEntry create = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)create);
        Assert.assertEquals((Object)"Task", (Object)create.getEntityType());
        Assert.assertNull((Object)create.getOrgValue());
        Assert.assertNull((Object)create.getNewValue());
        Assert.assertNull((Object)create.getProperty());
        Assert.assertEquals((Object)"TaskWorker", (Object)create.getCategory());
        this.task.setAssignee("icke");
        this.task.setName("to do");
        this.taskService.saveTask(this.task);
        List entries = this.queryOperationDetails("Update").list();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)((UserOperationLogEntry)entries.get(0)).getOperationId(), (Object)((UserOperationLogEntry)entries.get(1)).getOperationId());
        Assert.assertEquals((Object)"TaskWorker", (Object)((UserOperationLogEntry)entries.get(0)).getCategory());
        Assert.assertEquals((Object)"TaskWorker", (Object)((UserOperationLogEntry)entries.get(1)).getCategory());
    }

    @Test
    public void testMultipleValueChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.task.setName("a task");
        this.task.setName("to do");
        this.taskService.saveTask(this.task);
        UserOperationLogEntry update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        Assert.assertNull((Object)update.getOrgValue());
        Assert.assertEquals((Object)"to do", (Object)update.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)update.getCategory());
    }

    @Test
    public void testSetDateProperty() {
        this.task = this.taskService.newTask();
        Date now = ClockUtil.getCurrentTime();
        this.task.setDueDate(now);
        this.taskService.saveTask(this.task);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertEquals((Object)String.valueOf(now.getTime()), (Object)logEntry.getNewValue());
    }

    @Test
    public void testResetChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        String name = "a task";
        this.task.setName(name);
        this.taskService.saveTask(this.task);
        UserOperationLogEntry update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        Assert.assertNull((Object)update.getOrgValue());
        Assert.assertEquals((Object)name, (Object)update.getNewValue());
        this.task.setName("to do 1");
        this.task.setName("to do 2");
        this.task.setName(name);
        this.taskService.saveTask(this.task);
        update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        Assert.assertNull((Object)update.getOrgValue());
        Assert.assertEquals((Object)name, (Object)update.getNewValue());
    }

    @Test
    public void testConcurrentTaskChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.task.setAssignee("icke");
        this.taskService.setAssignee(this.task.getId(), "er");
        try {
            this.taskService.saveTask(this.task);
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testCaseInstanceId() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        UserOperationLogQuery query = this.queryOperationDetails("Update");
        Assert.assertEquals((long)0L, (long)query.count());
        this.task.setCaseInstanceId("aCaseInstanceId");
        this.taskService.saveTask(this.task);
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)entry.getNewValue());
        Assert.assertEquals((Object)"caseInstanceId", (Object)entry.getProperty());
        this.task.setCaseInstanceId("anotherCaseInstanceId");
        this.taskService.saveTask(this.task);
        Assert.assertEquals((long)2L, (long)query.count());
        List entries = query.list();
        Assert.assertEquals((long)2L, (long)entries.size());
        for (UserOperationLogEntry currentEntry : entries) {
            if (currentEntry.getId().equals(entry.getId())) continue;
            Assert.assertEquals((Object)"aCaseInstanceId", (Object)currentEntry.getOrgValue());
            Assert.assertEquals((Object)"anotherCaseInstanceId", (Object)currentEntry.getNewValue());
            Assert.assertEquals((Object)"caseInstanceId", (Object)currentEntry.getProperty());
        }
    }

    private UserOperationLogQuery queryOperationDetails(String type) {
        return this.historyService.createUserOperationLogQuery().operationType(type);
    }
}

