/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.List;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ClockTestUtil;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractJobExecutorAcquireJobsTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl configuration;
    private boolean jobExecutorAcquireByDueDate;
    private boolean jobExecutorAcquireByPriority;
    private boolean jobExecutorPreferTimerJobs;
    private boolean jobEnsureDueDateSet;
    private Long jobExecutorPriorityRangeMin;
    private Long jobExecutorPriorityRangeMax;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.managementService = this.rule.getManagementService();
    }

    @Before
    public void saveProcessEngineConfiguration() {
        this.configuration = (ProcessEngineConfigurationImpl)this.rule.getProcessEngine().getProcessEngineConfiguration();
        this.jobExecutorAcquireByDueDate = this.configuration.isJobExecutorAcquireByDueDate();
        this.jobExecutorAcquireByPriority = this.configuration.isJobExecutorAcquireByPriority();
        this.jobExecutorPreferTimerJobs = this.configuration.isJobExecutorPreferTimerJobs();
        this.jobEnsureDueDateSet = this.configuration.isEnsureJobDueDateNotNull();
        this.jobExecutorPriorityRangeMin = this.configuration.getJobExecutorPriorityRangeMin();
        this.jobExecutorPriorityRangeMax = this.configuration.getJobExecutorPriorityRangeMax();
    }

    @Before
    public void setClock() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
    }

    @After
    public void restoreProcessEngineConfiguration() {
        this.configuration.setJobExecutorAcquireByDueDate(this.jobExecutorAcquireByDueDate);
        this.configuration.setJobExecutorAcquireByPriority(this.jobExecutorAcquireByPriority);
        this.configuration.setJobExecutorPreferTimerJobs(this.jobExecutorPreferTimerJobs);
        this.configuration.setEnsureJobDueDateNotNull(this.jobEnsureDueDateSet);
        this.configuration.setJobExecutorPriorityRangeMin(this.jobExecutorPriorityRangeMin.longValue());
        this.configuration.setJobExecutorPriorityRangeMax(this.jobExecutorPriorityRangeMax.longValue());
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    protected List<AcquirableJobEntity> findAcquirableJobs() {
        return (List)this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<List<AcquirableJobEntity>>(){

            public List<AcquirableJobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }

    protected String startProcess(String processDefinitionKey, String activity) {
        return ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(processDefinitionKey).startBeforeActivity(activity)).execute().getId();
    }

    protected void startProcess(String processDefinitionKey, String activity, int times) {
        for (int i = 0; i < times; ++i) {
            this.startProcess(processDefinitionKey, activity);
        }
    }

    protected Job findJobById(String id) {
        return (Job)this.managementService.createJobQuery().jobId(id).singleResult();
    }
}

