/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.junit.Assert;

public class JobAcquisitionTestHelper {
    public static void suspendInstances(ProcessEngine processEngine, int numInstances) {
        List instancesToSuspend = processEngine.getRuntimeService().createProcessInstanceQuery().active().listPage(0, numInstances);
        if (instancesToSuspend.size() < numInstances) {
            throw new ProcessEngineException("Cannot suspend " + numInstances + " process instances");
        }
        for (ProcessInstance activeInstance : instancesToSuspend) {
            processEngine.getRuntimeService().suspendProcessInstanceById(activeInstance.getId());
        }
    }

    public static void activateInstances(ProcessEngine processEngine, int numInstances) {
        List instancesToActivate = processEngine.getRuntimeService().createProcessInstanceQuery().suspended().listPage(0, numInstances);
        if (instancesToActivate.size() < numInstances) {
            throw new ProcessEngineException("Cannot activate " + numInstances + " process instances");
        }
        for (ProcessInstance suspendedInstance : instancesToActivate) {
            processEngine.getRuntimeService().activateProcessInstanceById(suspendedInstance.getId());
        }
    }

    public static void assertInBetween(long minimum, long maximum, long actualValue) {
        Assert.assertTrue((String)("Expected '" + actualValue + "' to be between '" + minimum + "' and '" + maximum + "'"), (actualValue >= minimum && actualValue <= maximum ? 1 : 0) != 0);
    }
}

