/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ReducedJobExceptionLoggingTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch("org.eximeebpms.bpm.engine.jobexecutor", Level.DEBUG);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.loggingRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getProcessEngine().getManagementService();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setEnableReducedJobExceptionLogging(false);
        List jobs = this.managementService.createJobQuery().processDefinitionKey("failingProcess").list();
        for (Job job : jobs) {
            this.managementService.deleteJob(job.getId());
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void shouldLogAllFailingJobExceptions() {
        this.processEngineConfiguration.setEnableReducedJobExceptionLogging(false);
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Exception while executing job");
        Assertions.assertThat((int)filteredLogList.size()).isEqualTo(3);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void shouldLogOnlyOneFailingJobException() {
        this.processEngineConfiguration.setEnableReducedJobExceptionLogging(true);
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Exception while executing job");
        Assertions.assertThat((int)filteredLogList.size()).isEqualTo(1);
    }
}

