/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.persistence;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DatabaseNamingConsistencyTest {
    public static String COLUMN_NAME_REGEX = "([a-zA-Z_]*(?=[a-z]+)[a-zA-Z_]+_)[,\\s]";
    public static String[] SCANNED_FOLDERS = new String[]{"org/eximeebpms/bpm/engine/impl/mapping/entity/", "org/eximeebpms/bpm/engine/db/create", "org/eximeebpms/bpm/engine/db/drop", "org/eximeebpms/bpm/engine/db/liquibase/baseline"};

    @Test
    public void shouldNotFindLowercaseDbColumnNamesInMappings() {
        StringBuilder errorMessageBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile(COLUMN_NAME_REGEX);
        try {
            for (String scannedFolder : SCANNED_FOLDERS) {
                File[] filesInFolder;
                URL resource = this.getClass().getClassLoader().getResource(scannedFolder);
                if (resource == null) {
                    throw new IOException("Could not find path: " + scannedFolder);
                }
                File folder = new File(resource.getFile());
                for (File file : filesInFolder = folder.listFiles()) {
                    AtomicInteger lineNumber = new AtomicInteger(0);
                    try (Stream<String> lines = Files.lines(file.toPath());){
                        lines.forEach(line -> {
                            lineNumber.getAndIncrement();
                            Matcher matcher = pattern.matcher((CharSequence)line);
                            while (matcher.find()) {
                                errorMessageBuilder.append("Found illegal lowercase column name " + matcher.group(1) + " in SQL " + String.valueOf(file) + " at line " + String.valueOf(lineNumber) + ". All SQL column names should be uppercase.\n");
                            }
                        });
                    }
                }
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("Unable to find test resource for test " + this.getClass().getName() + "\n" + e.getMessage()));
        }
        String errorMessage = errorMessageBuilder.toString();
        if (!errorMessage.isEmpty()) {
            Assertions.fail((String)errorMessage);
        }
    }

    @Test
    public void shouldFindLowercaseDbColumnNamesInTestStrings() {
        String[] testStringsIncorrect = new String[]{"alter table ACT_RU_TASK add column TASK_sTATE_ varchar(64);", "${queryType} E.BUSINESS_kEY_ = #{query.processInstanceBusinessKey}", "and RES.AssIGNEE_ is null"};
        String[] testStringsCorrect = new String[]{"alter table ACT_RU_TASK add column TASK_STATE_ varchar(64);", "${queryType} E.BUSINESS_KEY_ = #{query.processInstanceBusinessKey}", "and RES.ASSIGNEE_ is null"};
        String[] testStrings = (String[])Stream.concat(Arrays.stream(testStringsIncorrect), Arrays.stream(testStringsCorrect)).toArray(String[]::new);
        Pattern pattern = Pattern.compile(COLUMN_NAME_REGEX);
        ArrayList<String> errors = new ArrayList<String>();
        for (String testString : testStrings) {
            Matcher matcher = pattern.matcher(testString);
            if (!matcher.find()) continue;
            errors.add(testString);
        }
        Assertions.assertThat(errors).containsAll(Arrays.asList(testStringsIncorrect));
        Assertions.assertThat(errors).doesNotContainAnyElementsOf(Arrays.asList(testStringsCorrect));
    }
}

