/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.FilterService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricTaskInstanceQueryOrTest {
    @Rule
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected RepositoryService repositoryService;
    protected FilterService filterService;

    @Before
    public void init() {
        this.historyService = this.processEngineRule.getHistoryService();
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.caseService = this.processEngineRule.getCaseService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
        this.filterService = this.processEngineRule.getFilterService();
    }

    @After
    public void tearDown() {
        for (org.eximeebpms.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        for (HistoricTaskInstance task : this.historyService.createHistoricTaskInstanceQuery().list()) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void shouldThrowExceptionByMissingStartOr() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().endOr().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set endOr() before or()");
    }

    @Test
    public void shouldThrowExceptionByNesting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().or().endOr().endOr().or().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set or() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionByWithCandidateGroupsApplied() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().withCandidateGroups().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set withCandidateGroups() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionByWithoutCandidateGroupsApplied() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().withoutCandidateGroups().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set withoutCandidateGroups() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTenantId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTenantId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTenantId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricActivityInstanceId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricActivityInstanceId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByHistoricActivityInstanceId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByProcessDefinitionId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByProcessInstanceId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByExecutionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByExecutionId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByExecutionId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricTaskInstanceDuration() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricTaskInstanceDuration().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByHistoricTaskInstanceDuration() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricTaskInstanceEndTime() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricTaskInstanceEndTime().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByHistoricTaskInstanceEndTime() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricActivityInstanceStartTime() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricTaskInstanceEndTime().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByHistoricTaskInstanceEndTime() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskName().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskName() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskDescription() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskDescription().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskDescription() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskAssignee() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskAssignee().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskAssignee() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskOwner() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskOwner().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskOwner() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskDueDate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskDueDate().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskDueDate() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskFollowUpDate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskFollowUpDate().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskFollowUpDate() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByDeleteReason() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByDeleteReason().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByDeleteReason() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskDefinitionKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskDefinitionKey().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskDefinitionKey() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskPriority() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskPriority().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTaskPriority() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByCaseDefinitionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByCaseDefinitionId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByCaseDefinitionId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByCaseInstanceId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByCaseInstanceId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByCaseInstanceId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByCaseExecutionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricTaskInstanceQuery().or().orderByCaseExecutionId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByCaseExecutionId() within 'or' query");
    }

    @Test
    public void shouldReturnHistoricTasksWithEmptyOrQuery() {
        this.taskService.saveTask(this.taskService.newTask());
        this.taskService.saveTask(this.taskService.newTask());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWithTaskNameOrTaskDescription() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWithMultipleOrCriteria() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setPriority(5);
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setOwner("aTaskOwner");
        this.taskService.saveTask(task5);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").taskId(task3.getId()).taskPriority(Integer.valueOf(5)).taskOwner("aTaskOwner").endOr().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksFilteredByMultipleOrAndCriteria() {
        Task task1 = this.taskService.newTask();
        task1.setPriority(4);
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("aTaskName");
        task2.setOwner("aTaskOwner");
        task2.setAssignee("aTaskAssignee");
        task2.setPriority(4);
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("aTaskName");
        task3.setOwner("aTaskOwner");
        task3.setAssignee("aTaskAssignee");
        task3.setPriority(4);
        task3.setDescription("aTaskDescription");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setOwner("aTaskOwner");
        task4.setAssignee("aTaskAssignee");
        task4.setPriority(4);
        task4.setDescription("aTaskDescription");
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setDescription("aTaskDescription");
        task5.setOwner("aTaskOwner");
        this.taskService.saveTask(task5);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").taskId(task3.getId()).endOr().taskOwner("aTaskOwner").taskPriority(Integer.valueOf(4)).taskAssignee("aTaskAssignee").list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksFilteredByMultipleOrQueries() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("aTaskName");
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("aTaskName");
        task3.setDescription("aTaskDescription");
        task3.setOwner("aTaskOwner");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setName("aTaskName");
        task4.setDescription("aTaskDescription");
        task4.setOwner("aTaskOwner");
        task4.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setName("aTaskName");
        task5.setDescription("aTaskDescription");
        task5.setOwner("aTaskOwner");
        task5.setAssignee("aTaskAssignee");
        task5.setPriority(4);
        this.taskService.saveTask(task5);
        Task task6 = this.taskService.newTask();
        task6.setName("aTaskName");
        task6.setDescription("aTaskDescription");
        task6.setOwner("aTaskOwner");
        task6.setAssignee("aTaskAssignee");
        task6.setPriority(4);
        this.taskService.saveTask(task6);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").endOr().or().taskName("aTaskName").taskDescription("aTaskDescription").taskAssignee("aTaskAssignee").endOr().or().taskName("aTaskName").taskDescription("aTaskDescription").taskOwner("aTaskOwner").taskAssignee("aTaskAssignee").endOr().or().taskAssignee("aTaskAssignee").taskPriority(Integer.valueOf(4)).endOr().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWhereSameCriterionWasAppliedThreeTimesInOneQuery() {
        Task task1 = this.taskService.newTask();
        task1.setName("task1");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("task2");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("task3");
        this.taskService.saveTask(task3);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("task1").taskName("task2").taskName("task3").endOr().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWithActivityInstanceIdInOrTaskId() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        String activityInstanceId = this.runtimeService.getActivityInstance(processInstance1.getId()).getChildActivityInstances()[0].getId();
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().activityInstanceIdIn(new String[]{activityInstanceId}).taskId(task2.getId()).endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldTestDueDateCombinations() throws ParseException {
        HashMap<String, Date> dates = this.createFollowUpAndDueDateTasks();
        this.taskService.saveTask(this.taskService.newTask());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueBefore(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueBefore(dates.get("oneHourAgo")).withoutTaskDueDate().endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueAfter(dates.get("oneHourLater")).withoutTaskDueDate().endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueBefore(dates.get("oneHourAgo")).taskDueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueBefore(dates.get("oneHourAgo")).taskDueAfter(dates.get("oneHourLater")).withoutTaskDueDate().endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueBefore(dates.get("oneHourLater")).taskDueAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueBefore(dates.get("oneHourLater")).taskDueAfter(dates.get("oneHourAgo")).withoutTaskDueDate().endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueBefore(dates.get("oneHourAgo")).taskDueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueBefore(dates.get("oneHourAgo")).taskDueAfter(dates.get("oneHourLater")).withoutTaskDueDate().endOr().count());
    }

    @Test
    public void shouldTestFollowUpDateCombinations() throws ParseException {
        HashMap<String, Date> dates = this.createFollowUpAndDueDateTasks();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpDate(dates.get("date")).taskFollowUpBefore(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpDate(dates.get("date")).taskFollowUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpBefore(dates.get("oneHourAgo")).taskFollowUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpBefore(dates.get("oneHourLater")).taskFollowUpAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpDate(dates.get("date")).taskFollowUpBefore(dates.get("oneHourAgo")).taskFollowUpAfter(dates.get("oneHourLater")).endOr().count());
        this.taskService.saveTask(this.taskService.newTask());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
    }

    @Test
    public void shouldQueryStartedBeforeOrAfter() {
        Date dateOne = new Date(1363607000000L);
        ClockUtil.setCurrentTime((Date)dateOne);
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        Date dateTwo = new Date(dateOne.getTime() + 7000000L);
        ClockUtil.setCurrentTime((Date)dateTwo);
        Task taskTwo = this.taskService.newTask();
        this.taskService.saveTask(taskTwo);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().startedBefore(new Date(dateOne.getTime() + 1000L)).startedAfter(new Date(dateTwo.getTime() - 1000L)).endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryStandaloneOrEmbeddedTaskByProcessDefinitionKey() {
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskId(taskOne.getId()).processDefinitionKey("oneTaskProcess").endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryStandaloneOrEmbeddedTaskByProcessInstanceId() {
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "aBusinessKey");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskId(taskOne.getId()).processInstanceBusinessKey("aBusinessKey").endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void shouldQueryStandaloneOrEmbeddedTaskByCaseDefinitionId() {
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskId(taskOne.getId()).caseDefinitionKey("oneTaskCase").endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    public void shouldQueryFinishedBeforeOrAfter() {
        Date dateOne = new Date(1363607000000L);
        ClockUtil.setCurrentTime((Date)dateOne);
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.taskService.complete(taskOne.getId());
        Date dateTwo = new Date(dateOne.getTime() + 7000000L);
        ClockUtil.setCurrentTime((Date)dateTwo);
        Task taskTwo = this.taskService.newTask();
        this.taskService.saveTask(taskTwo);
        this.taskService.complete(taskTwo.getId());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().finishedBefore(new Date(dateOne.getTime() + 1000L)).finishedAfter(new Date(dateTwo.getTime() - 1000L)).endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldReturnHistoricTasksWithHadCandidateUserOrHadCandidateGroup() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateUser(task1.getId(), "USER_TEST");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "GROUP_TEST");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskHadCandidateUser("USER_TEST").taskHadCandidateGroup("GROUP_TEST").endOr().list();
        Assertions.assertThat((List)tasks).hasSize(2);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldReturnHistoricTasksWithCandidateCandidateUserInvolvedOrCandidateGroupInvolved() {
        Task task1 = this.taskService.newTask();
        this.taskService.saveTask(task1);
        this.taskService.addCandidateUser(task1.getId(), "USER_TEST");
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        this.taskService.addCandidateGroup(task2.getId(), "GROUP_TEST");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskInvolvedUser("USER_TEST").taskInvolvedGroup("GROUP_TEST").endOr().list();
        Assertions.assertThat((List)tasks).hasSize(2);
    }

    public HashMap<String, Date> createFollowUpAndDueDateTasks() throws ParseException {
        final Date date = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("27/07/2017 01:12:13");
        final Date oneHourAgo = new Date(date.getTime() - 3600000L);
        final Date oneHourLater = new Date(date.getTime() + 3600000L);
        Task taskDueBefore = this.taskService.newTask();
        taskDueBefore.setFollowUpDate(new Date(oneHourAgo.getTime() - 1000L));
        taskDueBefore.setDueDate(new Date(oneHourAgo.getTime() - 1000L));
        this.taskService.saveTask(taskDueBefore);
        Task taskDueDate = this.taskService.newTask();
        taskDueDate.setFollowUpDate(date);
        taskDueDate.setDueDate(date);
        this.taskService.saveTask(taskDueDate);
        Task taskDueAfter = this.taskService.newTask();
        taskDueAfter.setFollowUpDate(new Date(oneHourLater.getTime() + 1000L));
        taskDueAfter.setDueDate(new Date(oneHourLater.getTime() + 1000L));
        this.taskService.saveTask(taskDueAfter);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        return new HashMap<String, Date>(){
            {
                this.put("date", date);
                this.put("oneHourAgo", oneHourAgo);
                this.put("oneHourLater", oneHourLater);
            }
        };
    }
}

