/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.pvm;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.eximeebpms.bpm.engine.impl.pvm.PvmExecution;
import org.eximeebpms.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.eximeebpms.bpm.engine.impl.pvm.PvmProcessInstance;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.ExecutionImpl;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.Automatic;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.EmbeddedSubProcess;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.EventScopeCreatingSubprocess;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.WaitState;
import org.junit.Assert;
import org.junit.Test;

public class PvmEventScopesTest {
    @Test
    public void testActivityEndDestroysEventScopes() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EventScopeCreatingSubprocess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new Automatic()).endActivity().transition("wait").endActivity().createActivity("wait").behavior((ActivityBehavior)new WaitState()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new Automatic()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        boolean eventScopeFound = false;
        List executions = ((ExecutionImpl)processInstance).getExecutions();
        for (ExecutionImpl executionImpl : executions) {
            if (!executionImpl.isEventScope()) continue;
            eventScopeFound = true;
            break;
        }
        Assert.assertTrue((boolean)eventScopeFound);
        processInstance.signal(null, null);
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testTransitionDestroysEventScope() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("nestedSubProcess").endActivity().createActivity("nestedSubProcess").scope().behavior((ActivityBehavior)new EventScopeCreatingSubprocess()).createActivity("startNestedInside").behavior((ActivityBehavior)new Automatic()).endActivity().transition("wait").endActivity().createActivity("wait").behavior((ActivityBehavior)new WaitState()).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new Automatic()).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new Automatic()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedActiveActivityIds = new ArrayList<String>();
        expectedActiveActivityIds.add("wait");
        Assert.assertEquals(expectedActiveActivityIds, (Object)processInstance.findActiveActivityIds());
        PvmExecution execution = processInstance.findExecution("wait");
        execution.signal(null, null);
        Assert.assertTrue((boolean)processInstance.isEnded());
    }
}

