/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.variables;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Scanner;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.variable.serializer.FileValueSerializer;
import org.eximeebpms.bpm.engine.impl.variable.serializer.ValueFields;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.impl.type.FileValueTypeImpl;
import org.eximeebpms.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.eximeebpms.bpm.engine.variable.value.FileValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.Before;
import org.junit.Test;

public class FileValueSerializerTest {
    private static final String SEPARATOR = "#";
    private FileValueSerializer serializer;

    @Before
    public void setUp() {
        this.serializer = new FileValueSerializer();
    }

    @Test
    public void testTypeIsFileValueType() {
        Assertions.assertThat((Object)this.serializer.getType()).isInstanceOf(FileValueTypeImpl.class);
    }

    @Test
    public void testWriteFilenameOnlyValue() {
        String filename = "test.txt";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((byte[])valueFields.getByteArrayValue()).isNull();
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)filename);
        Assertions.assertThat((String)valueFields.getTextValue2()).isNull();
    }

    @Test
    public void testWriteEmptyFilenameOnlyValue() {
        String filename = "";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((byte[])valueFields.getByteArrayValue()).isNull();
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)filename);
        Assertions.assertThat((String)valueFields.getTextValue2()).isNull();
    }

    @Test
    public void testWriteMimetypeAndFilenameValue() {
        String filename = "test.txt";
        String mimeType = "text/json";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((byte[])valueFields.getByteArrayValue()).isNull();
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)filename);
        Assertions.assertThat((String)valueFields.getTextValue2()).isEqualTo((Object)(mimeType + SEPARATOR));
    }

    @Test
    public void testWriteMimetypeFilenameAndBytesValue() throws UnsupportedEncodingException {
        String filename = "test.txt";
        String mimeType = "text/json";
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt");
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).file(is).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((String)new String(valueFields.getByteArrayValue(), "UTF-8")).isEqualTo((Object)"text");
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)filename);
        Assertions.assertThat((String)valueFields.getTextValue2()).isEqualTo((Object)(mimeType + SEPARATOR));
    }

    @Test
    public void testWriteMimetypeFilenameBytesValueAndEncoding() throws UnsupportedEncodingException {
        String filename = "test.txt";
        String mimeType = "text/json";
        Charset encoding = Charset.forName("UTF-8");
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt");
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).encoding(encoding).file(is).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((String)new String(valueFields.getByteArrayValue(), "UTF-8")).isEqualTo((Object)"text");
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)filename);
        Assertions.assertThat((String)valueFields.getTextValue2()).isEqualTo((Object)(mimeType + SEPARATOR + encoding.name()));
    }

    @Test
    public void testWriteMimetypeFilenameAndBytesValueWithShortcutMethod() throws URISyntaxException, UnsupportedEncodingException {
        File file = new File(this.getClass().getClassLoader().getResource("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt").toURI());
        FileValue fileValue = Variables.fileValue((File)file);
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((String)new String(valueFields.getByteArrayValue(), "UTF-8")).isEqualTo((Object)"text");
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)"simpleFile.txt");
        Assertions.assertThat((String)valueFields.getTextValue2()).isEqualTo((Object)"text/plain#");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testThrowsExceptionWhenConvertingUnknownUntypedValueToTypedValue() {
        this.serializer.convertToTypedValue((UntypedValueImpl)Variables.untypedValue((Object)new Object()));
    }

    @Test
    public void testReadFileNameMimeTypeAndByteArray() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        String mimeType = "text/plain";
        valueFields.setTextValue2(mimeType + SEPARATOR);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((String)fileValue.getMimeType()).isEqualTo((Object)mimeType);
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFileNameEncodingAndByteArray() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        String encoding = "#UTF-8";
        valueFields.setTextValue2(encoding);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((String)fileValue.getEncoding()).isEqualTo((Object)"UTF-8");
        Assertions.assertThat((Comparable)fileValue.getEncodingAsCharset()).isEqualTo((Object)Charset.forName("UTF-8"));
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFullValue() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        String mimeType = "text/plain";
        String encoding = "UTF-16";
        valueFields.setTextValue2(mimeType + SEPARATOR + encoding);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((String)fileValue.getMimeType()).isEqualTo((Object)mimeType);
        Assertions.assertThat((String)fileValue.getEncoding()).isEqualTo((Object)"UTF-16");
        Assertions.assertThat((Comparable)fileValue.getEncodingAsCharset()).isEqualTo((Object)Charset.forName("UTF-16"));
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFilenameAndByteArrayValue() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/eximeebpms/bpm/engine/test/standalone/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((String)fileValue.getMimeType()).isNull();
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFilenameValue() throws IOException {
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((String)fileValue.getMimeType()).isNull();
        Assertions.assertThat((InputStream)fileValue.getValue()).isNull();
    }

    @Test
    public void testReadEmptyFilenameValue() {
        MockValueFields valueFields = new MockValueFields();
        String filename = "";
        valueFields.setTextValue(filename);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)"");
        Assertions.assertThat((String)fileValue.getMimeType()).isNull();
        Assertions.assertThat((InputStream)fileValue.getValue()).isNull();
    }

    @Test
    public void testReadNullFilenameValue() {
        MockValueFields valueFields = new MockValueFields();
        String filename = null;
        valueFields.setTextValue(filename);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true, false);
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)"");
        Assertions.assertThat((String)fileValue.getMimeType()).isNull();
        Assertions.assertThat((InputStream)fileValue.getValue()).isNull();
    }

    @Test
    public void testNameIsFile() {
        Assertions.assertThat((String)this.serializer.getName()).isEqualTo((Object)"file");
    }

    @Test
    public void testWriteFilenameAndEncodingValue() {
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).encoding(encoding).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assertions.assertThat((byte[])valueFields.getByteArrayValue()).isNull();
        Assertions.assertThat((String)valueFields.getTextValue()).isEqualTo((Object)filename);
        Assertions.assertThat((String)valueFields.getTextValue2()).isEqualTo((Object)(SEPARATOR + encoding));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerializeFileValueWithoutName() {
        Variables.fileValue((String)null).file("abc".getBytes()).create();
    }

    private void checkStreamFromValue(TypedValue value, String expected) {
        InputStream stream = (InputStream)value.getValue();
        try (Scanner scanner = new Scanner(stream);){
            Assertions.assertThat((String)scanner.nextLine()).isEqualTo((Object)expected);
        }
    }

    private static class MockValueFields
    implements ValueFields {
        private String name;
        private String textValue;
        private String textValue2;
        private Long longValue;
        private Double doubleValue;
        private byte[] bytes;

        private MockValueFields() {
        }

        public String getName() {
            return this.name;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        public String getTextValue2() {
            return this.textValue2;
        }

        public void setTextValue2(String textValue2) {
            this.textValue2 = textValue2;
        }

        public Long getLongValue() {
            return this.longValue;
        }

        public void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        public Double getDoubleValue() {
            return this.doubleValue;
        }

        public void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public byte[] getByteArrayValue() {
            return this.bytes;
        }

        public void setByteArrayValue(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

