/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.util;

import java.util.List;
import java.util.function.Consumer;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.ProcessEngines;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ProcessEngineBootstrapRule
extends TestWatcher {
    private ProcessEngine processEngine;
    protected Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator;

    public ProcessEngineBootstrapRule() {
        this("eximeebpms.cfg.xml");
    }

    public ProcessEngineBootstrapRule(String configurationResource) {
        this(configurationResource, null);
    }

    public ProcessEngineBootstrapRule(Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator) {
        this("eximeebpms.cfg.xml", processEngineConfigurator);
    }

    public ProcessEngineBootstrapRule(String configurationResource, Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator) {
        this.processEngineConfigurator = processEngineConfigurator;
        this.processEngine = this.bootstrapEngine(configurationResource);
    }

    public ProcessEngine bootstrapEngine(String configurationResource) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)configurationResource);
        this.configureEngine(processEngineConfiguration);
        return processEngineConfiguration.buildProcessEngine();
    }

    public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
        if (this.processEngineConfigurator != null) {
            this.processEngineConfigurator.accept(configuration);
        }
        return configuration;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    protected void finished(Description description) {
        this.deleteHistoryCleanupJob();
        this.processEngine.close();
        ProcessEngines.unregister((ProcessEngine)this.processEngine);
        this.processEngine = null;
    }

    private void deleteHistoryCleanupJob() {
        List jobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        for (final Job job : jobs) {
            ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                    return null;
                }
            });
        }
    }
}

