/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.compensate.helper;

import java.util.ArrayList;
import java.util.List;

import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.Expression;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;

/**
 * @author Daniel Meyer
 */
public class SetVariablesDelegate implements JavaDelegate {

  private Expression variable;
  public static List<String> values = new ArrayList<String>();

  public void execute(DelegateExecution execution) throws Exception {

    String variableName = (String) variable.getValue(execution);
    String value = values.iterator().next();

    execution.setVariableLocal(variableName, value);

    values.remove(value);
  }

  public static void setValues(List<String> values) {
    SetVariablesDelegate.values.clear();
    SetVariablesDelegate.values.addAll(values);
  }

}
