/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.util;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Rule;
import org.junit.Test;

public class StringUtilTest {
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();

    @Test
    public void shouldAllowTrimToMaximumLength() {
        String fittingThreeByteMessage = StringUtilTest.repeatCharacter("\u9faf", StringUtil.DB_MAX_STRING_LENGTH);
        String exceedingMessage = StringUtilTest.repeatCharacter("a", StringUtil.DB_MAX_STRING_LENGTH * 2);
        Assertions.assertThat((String)fittingThreeByteMessage.substring(0, StringUtil.DB_MAX_STRING_LENGTH)).isEqualTo((Object)StringUtil.trimToMaximumLengthAllowed((String)fittingThreeByteMessage));
        Assertions.assertThat((String)exceedingMessage.substring(0, StringUtil.DB_MAX_STRING_LENGTH)).isEqualTo((Object)StringUtil.trimToMaximumLengthAllowed((String)exceedingMessage));
    }

    @Test
    public void shouldConvertByteArrayToString() {
        String message = "This is a message string";
        byte[] bytes = message.getBytes();
        String stringFromBytes = StringUtil.fromBytes((byte[])bytes, (ProcessEngine)this.engineRule.getProcessEngine());
        Assertions.assertThat((String)stringFromBytes).isEqualTo((Object)message);
    }

    @Test
    public void shouldConvertNullByteArrayToEmptyString() {
        byte[] bytes = null;
        String stringFromBytes = StringUtil.fromBytes(bytes, (ProcessEngine)this.engineRule.getProcessEngine());
        Assertions.assertThat((String)stringFromBytes).isEmpty();
    }

    protected static String repeatCharacter(String encodedCharacter, int numCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numCharacters; ++i) {
            sb.append(encodedCharacter);
        }
        return sb.toString();
    }
}

